/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.Visitor;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.ChangeSetAncestryProcessor;
import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class P4ChangeSetAncestryProcessor
extends ChangeSetAncestryProcessor {
    private P4Cache cache;

    public P4ChangeSetAncestryProcessor(P4Cache cache) {
        super(cache.getChangeSetDAO());
        this.cache = cache;
    }

    @Override
    public boolean process(MutableChangeSet changeset) throws DbException {
        boolean changed = super.process(changeset);
        if (!FishEyeSysProps.P4_ANCESTRY_DISABLE) {
            final HashMap branchParentMap = new HashMap();
            changeset.visitRevisions(new Visitor<FileRevision>(){

                @Override
                public void visit(FileRevision rev) {
                    if (rev.getAncestorLink() != null && rev.getAncestorLink().isBranchPoint()) {
                        String branch = rev.getBranch();
                        for (RevInfoKey key : rev.getAncestors()) {
                            FileRevision ancestor = P4ChangeSetAncestryProcessor.this.cache.getFileRevision(key);
                            String ancestorBranch = ancestor.getBranch();
                            long changeList = Long.parseLong(key.getRev());
                            Pair<String, String> mapKey = Pair.newInstance(branch, ancestorBranch);
                            if (branchParentMap.containsKey(mapKey) && (Long)branchParentMap.get(mapKey) >= changeList) continue;
                            branchParentMap.put(mapKey, changeList);
                        }
                    }
                }
            });
            if (!branchParentMap.isEmpty()) {
                HashSet<String> parentIds = new HashSet<String>();
                for (Long csid : branchParentMap.values()) {
                    parentIds.add(csid.toString());
                }
                HashSet<String> currentParents = new HashSet<String>(changeset.getParents());
                if (currentParents.addAll(parentIds)) {
                    changeset.setParents(new ArrayList<String>(currentParents));
                    changed = true;
                }
            }
        }
        return changed;
    }
}

