/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.Visitor;
import com.atlassian.utils.process.Watchdog;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathNotFoundException;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.BaseDirInfoCache;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.perforce.P4ChangeSetImpl;
import com.cenqua.fisheye.perforce.P4FileHistory;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.AnnotateCallBack;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4ClientFactory;
import com.cenqua.fisheye.perforce.client.P4Fix;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.db.P4ChangeSetDAO;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.perforce.db.P4RevInfoDAO;
import com.cenqua.fisheye.perforce.db.P4StringTables;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SortedMapFileHistory;
import com.cenqua.fisheye.rep.SyntheticBlameInfo;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.SuffixSearchUtil;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.TreeMultimap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class P4Cache
extends BaseDirInfoCache<P4RevInfo, P4ChangeSetImpl, P4StringTables> {
    private final P4RepositoryInfo repositoryInfo;
    private final GenericObjectPool clientPool;
    private final P4RevInfoDAO fileRevDAO;
    private final P4ChangeSetDAO csDAO;

    public P4Cache(long cacheSerial, int version, P4RepositoryInfo repInfo, LuceneConnection<LuceneIndexes> luceneConnection, InfinityDbHandle dbh, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext, P4ClientFactory clientFactory) {
        super(repInfo.getConfig().getStatus(), cacheSerial, version, dbh, luceneConnection, new P4StringTables(dbh), licenseEnforcer, indexingContext, repInfo.isCaseSensitive());
        this.repositoryInfo = repInfo;
        this.clientPool = new GenericObjectPool((PoolableObjectFactory)clientFactory);
        this.clientPool.setMaxActive(FishEyeSysProps.P4_CLIENTPOOL_MAX_CLIENTS);
        this.clientPool.setMaxIdle(3);
        this.clientPool.setWhenExhaustedAction((byte)1);
        this.clientPool.setMaxWait(20000L);
        this.fileRevDAO = new P4RevInfoDAO(this.getInfDb(), (P4StringTables)this.getStringTables(), this.repositoryInfo.isCaseSensitive(), this.repositoryInfo.getName(), this.getLicenseEnforcer());
        this.csDAO = new P4ChangeSetDAO(repInfo.getConfig().getStatus(), this.getInfDb(), (P4StringTables)this.getStringTables(), this.fileRevDAO, this.getLicenseEnforcer());
    }

    @Override
    public P4RevInfoDAO getFileRevisionDAO() {
        return this.fileRevDAO;
    }

    @Override
    public FileRevision findFileRevision(Path path, String revision) throws DbException {
        FileRevision fileRevision = super.findFileRevision(path, revision);
        if (fileRevision == null) {
            try {
                Long rev = Long.valueOf(revision);
                long latestPathChangeUpto = this.fileRevDAO.getLatestPathChangeUpto(path, rev);
                fileRevision = this.getFileRevision(new RevInfoKey(path, String.valueOf(latestPathChangeUpto)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fileRevision;
    }

    public P4ChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.repositoryInfo.isCaseSensitive();
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.fileRevDAO.getCommonRevInfoDAO();
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryInfo.getName();
    }

    @Override
    public String getDefaultBranch() {
        return "head";
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        int revid = this.fileRevDAO.getLatestPathRevid(path);
        return revid != -1 && this.fileRevDAO.getFileType(revid) == 1;
    }

    @Override
    public void getTextRevision(RevInfoKey key, OutputStream out, String kopt, String symrev) throws IOException, DbException {
        this.getBinaryRevision(key, out);
    }

    public void getTextRevision(RevInfoKey key, OutputStream out, String kopt) throws IOException, DbException {
        this.getTextRevision(key, out, kopt, null);
    }

    public P4Client allocateClient() throws DbException {
        try {
            return (P4Client)this.clientPool.borrowObject();
        }
        catch (Exception e2) {
            throw new DbException("Unable to allocate an P4 client for " + this.repositoryInfo.getServer(), e2);
        }
    }

    public void returnClient(P4Client client) {
        if (client != null) {
            try {
                this.clientPool.returnObject((Object)client);
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"Exception returning client instance", (Throwable)e2);
            }
        }
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, final OutputStream out) throws IOException, DbException {
        P4Client client = this.allocateClient();
        try {
            long changeListId;
            try {
                changeListId = Long.parseLong(key.getRev());
            }
            catch (NumberFormatException e2) {
                throw new NotFoundException("file/revision not found: " + key);
            }
            String filePath = this.repositoryInfo.getServerPath(key.getPath(), changeListId);
            final OutputStream x2 = new OutputStream(){

                @Override
                public void write(int b2) throws IOException {
                    out.write(b2);
                }
            };
            client.streamContent(filePath, changeListId, null, new P4Visitor.ProcessOutputVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void visit(Watchdog watchdog, InputStream is, String encoding) throws RuntimeWrappedException {
                    try {
                        OutputStream outputStream = x2;
                        synchronized (outputStream) {
                            IOHelper.copyStream(is, x2);
                        }
                    }
                    catch (IOException e2) {
                        try {
                            throw new RuntimeWrappedException(e2);
                        }
                        catch (Throwable throwable) {
                            IOHelper.close(is);
                            throw throwable;
                        }
                    }
                    IOHelper.close(is);
                }
            });
        }
        catch (P4ClientException e3) {
            Logs.APP_LOG.error((Object)("Exception loading P4 content for " + key), (Throwable)e3);
            throw new DbException("P4 Client exception fetching content: " + e3.getMessage(), e3);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public Charset getTextEncoding(RevInfoKey rkey) throws DbException {
        P4RevInfo revInfo = (P4RevInfo)this.getFileRevision(rkey);
        if (revInfo == null) {
            throw new DbException("Unable to locate revision for " + rkey);
        }
        Charset result = revInfo.isUnicode() ? (!this.repositoryInfo.isUnicode() ? Charset.forName("UTF-16") : Charset.forName("UTF-8")) : Charset.forName(this.repositoryInfo.getEncoding());
        return result;
    }

    @Override
    public FileRevision getFileRevision(int revid) throws DbException {
        return this.getFileRevision(revid, false);
    }

    @Override
    public FileRevision getFileRevision(int revid, boolean lazy) throws DbException {
        return lazy ? this.getFileRevisionDAO().loadLazy(revid) : this.getFileRevisionDAO().load(revid);
    }

    @Override
    public FileRevision getFileRevision(RevInfoKey rkey) throws DbException {
        long rev;
        try {
            rev = Long.parseLong(rkey.getRev());
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.debug((Object)("Invalid revision: " + rkey));
            return null;
        }
        int revid = this.fileRevDAO.getRevId(rkey.getPath(), rev);
        if (revid == -1) {
            Logs.APP_LOG.error((Object)("Could not determine revid for key " + rkey));
            return null;
        }
        return this.fileRevDAO.load(revid);
    }

    @Override
    public P4ChangeSetImpl getChangeSet(String csid) throws DbException {
        return (P4ChangeSetImpl)this.csDAO.load(csid);
    }

    @Override
    public String getChangeSetId(int revid) throws DbException {
        return this.getKey(revid).getRev();
    }

    @Override
    public FileHistory getFileHistory(Path path, boolean physicalOnly) throws DbException {
        SortedMap<Long, Integer> csids = this.fileRevDAO.getPathRevisions(path);
        TreeMultimap history = TreeMultimap.create();
        for (Map.Entry<Long, Integer> entry : csids.entrySet()) {
            Long csid = entry.getKey();
            Integer revid = entry.getValue();
            P4RevInfo revision = this.fileRevDAO.load(revid);
            history.put((Object)csid, (Object)revision);
        }
        return new P4FileHistory(path, (TreeMultimap<Long, FileRevision>)history);
    }

    @Override
    public FileHistory getFullFileHistory(Path path, boolean physicalOnly) throws DbException {
        if (physicalOnly) {
            return this.getFileHistory(path);
        }
        TreeMultimap ancestry = TreeMultimap.create();
        long latestCsid = this.fileRevDAO.getLatestPathChange(path);
        RevInfoKey key = new RevInfoKey(path, Long.toString(latestCsid));
        SortedMapFileHistory.addFileAncestry(this, (TreeMultimap<Long, FileRevision>)ancestry, key, true, false);
        return new P4FileHistory(path, (TreeMultimap<Long, FileRevision>)ancestry);
    }

    private String resolveRevisionForPatch(Path path, String revision) throws DbException {
        try {
            int revId = this.fileRevDAO.getRevIdByFileRev(path, Integer.parseInt(revision));
            if (revId == -1) {
                return null;
            }
            return this.fileRevDAO.getDisplayRevision(revId);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Override
    public Map<Path, String> resolveRevisionsForPatch(Map<Path, RevisionIdentifier> patchRevisions) throws DbException {
        HashMap<Path, String> revisions = new HashMap<Path, String>();
        for (Map.Entry<Path, RevisionIdentifier> entry : patchRevisions.entrySet()) {
            revisions.put(entry.getKey(), this.resolveRevisionForPatch(entry.getKey(), entry.getValue().getId()));
        }
        return revisions;
    }

    @Override
    public Blame getBlameFallback(final RevInfoKey revInfoKey) throws DbException, IOException {
        FileRevision revision = this.getFileHistory(revInfoKey.getPath()).getRevision(revInfoKey.getRev());
        if (revision == null) {
            throw new PathNotFoundException("File not found", this.getRepositoryName(), revInfoKey);
        }
        if (!revision.isAnnotatable()) {
            throw new PathNotFoundException("File is not annotatable", this.getRepositoryName(), revInfoKey);
        }
        P4Client client = this.allocateClient();
        try {
            long changeListId = Long.parseLong(revInfoKey.getRev());
            String fileSpec = this.repositoryInfo.getServerPath(revInfoKey.getPath(), changeListId);
            final ArrayList<BlameChunk> chunks = new ArrayList<BlameChunk>();
            AnnotateCallBack callback = new AnnotateCallBack(){
                private int lineNum = 0;
                private long currentRev = -1L;
                private BlameChunk currentChunk = null;
                private LoadingCache<RevInfoKey, Optional<FileRevision>> blameRevisionCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<RevInfoKey, Optional<FileRevision>>(){

                    public Optional<FileRevision> load(RevInfoKey key) throws Exception {
                        return Optional.ofNullable(P4Cache.this.getFileRevision(key));
                    }
                });

                @Override
                public void singleLine(long revision, String line) {
                    if (this.currentRev == revision && this.currentChunk.getLength() < 8000) {
                        this.currentChunk.incLength(1);
                    } else {
                        String rev = Long.toString(revision);
                        RevInfoKey rkey = new RevInfoKey(revInfoKey.getPath(), rev);
                        Optional fileRev = (Optional)this.blameRevisionCache.getUnchecked((Object)rkey);
                        this.currentChunk = !fileRev.isPresent() ? new BlameChunk(new SyntheticBlameInfo(rev, rev, revInfoKey.getPath()), this.lineNum, this.lineNum, 1) : new BlameChunk((FileRevision)fileRev.get(), this.lineNum, this.lineNum);
                        chunks.add(this.currentChunk);
                        this.currentRev = revision;
                    }
                    ++this.lineNum;
                }

                @Override
                public void continueLine(String line) {
                }
            };
            P4RevInfo revInfo = (P4RevInfo)revision;
            client.getBlame(fileSpec, revInfo.getP4FileType(), changeListId, this.repositoryInfo.isUnicode(), callback);
            Blame blame = new Blame(chunks);
            return blame;
        }
        catch (RepositoryClientException e2) {
            Logs.APP_LOG.error((Object)("Exception getting annotation for " + revInfoKey), (Throwable)e2);
            throw new IOException("Exception getting annotation blame: " + e2.getMessage());
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public List<String> getSimilarChangeSetIds(String id) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public List<String> findSimilarPartialChangeSetIds(String partialId) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.P4;
    }

    @Override
    public String getImpliedBranch(Path path) {
        return null;
    }

    public long getJobId(String jobName) throws DbException {
        return this.fileRevDAO.findJobId(jobName);
    }

    public P4Job getJob(String jobName) throws DbException {
        return this.fileRevDAO.loadJob(jobName);
    }

    @Override
    public FileRevision getLatestFileRevision(Path path) throws DbException {
        int revid = this.fileRevDAO.getLatestPathRevid(path);
        if (revid == -1) {
            Logs.APP_LOG.debug((Object)("No latest path rev for " + path));
            return null;
        }
        return this.getFileRevision(revid, true);
    }

    public LongSet getChangesets(long start, long end) throws DbException {
        return this.fileRevDAO.getChangeSets(start, end);
    }

    public void updateChangeSet(final P4ChangeSetImpl changeSet, final P4ChangeList changeList) throws DbException, LicensePolicyException {
        List<P4Fix> fixes = changeList.getFixes();
        final HashSet<String> jobs = new HashSet<String>(fixes.size());
        for (P4Fix fix : fixes) {
            jobs.add(fix.getJobName());
        }
        final CommonRevInfoDAO commonDAO = this.fileRevDAO.getCommonRevInfoDAO();
        changeSet.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revision) {
                if (!changeSet.getAuthor().equals(changeList.getAuthor())) {
                    commonDAO.updateAuthor(revision.getRevID(), changeList.getAuthor());
                }
                if (changeSet.getDate() != changeList.getDate()) {
                    commonDAO.updateDate(revision.getRevID(), changeList.getDate());
                }
                if (!changeSet.getComment().equals(changeList.getComment())) {
                    commonDAO.updateComment(revision.getRevID(), changeList.getComment());
                }
                P4Cache.this.fileRevDAO.updateFixedJobs(revision.getRevID(), jobs);
            }
        });
        changeSet.setAuthor(changeList.getAuthor());
        changeSet.setDate(changeList.getDate());
        changeSet.setComment(changeList.getComment());
        this.csDAO.store(changeSet);
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate) throws DbException {
        return this.getFileRevisionDAO().searchAncestors(revInfoKey, predicate, true);
    }

    @Override
    protected List<Path> findPathRoots(Path suffix, EggTimer timer) throws IOException, DbException {
        return SuffixSearchUtil.findPathRoots(this.getInfDb(), this.getCommonRevInfoDAO(), suffix, this.isCaseSensitive(), timer);
    }
}

