/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.util.AntGlob;

public class P4BranchMapping {
    private final AntGlob fromGlob;
    private final AntGlob toGlob;
    private final String from;
    private final String to;
    private final boolean negative;

    public P4BranchMapping(boolean negative, String from, String to) {
        this.negative = negative;
        this.from = from;
        this.to = to;
        this.fromGlob = this.createGlob(from);
        this.toGlob = this.createGlob(to);
    }

    private AntGlob createGlob(String spec) {
        if (spec.endsWith("...")) {
            spec = spec.substring(0, spec.length() - "...".length()) + "**";
        }
        return new AntGlob(spec.substring(1));
    }

    public String toString() {
        return (this.negative ? "-" : "") + this.from + "->" + this.to;
    }

    public boolean matches(P4ChangePath changePath) {
        return !this.negative && this.toGlob.matches(changePath.getPath().substring(1));
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public boolean isNegative() {
        return this.negative;
    }
}

