/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.model.manager.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.model.manager.dao.CommitterUserMappingDAO;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateCommitterUserMappingDAO
implements CommitterUserMappingDAO {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public HibernateCommitterUserMappingDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void add(CommitterUserMapping committerUserMapping) {
        this.session().save((Object)committerUserMapping);
    }

    @Override
    public void delete(CommitterUserMapping committerUserMapping) {
        this.session().delete((Object)committerUserMapping);
    }

    @Override
    public void deleteForUser(String userName) {
        Query q2 = this.session().createQuery("delete from CommitterUserMapping mapping where mapping.userName = :userName");
        q2.setString("userName", UserManager.USERNAME_NORMALIZATION.apply(userName));
        q2.executeUpdate();
    }

    @Override
    public List<CommitterUserMapping> list() {
        return this.listFor(null, null);
    }

    @Override
    public List<CommitterUserMapping> listForUser(String userName) {
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0, (Object)"userName cannot be null");
        return this.listFor(userName, null);
    }

    @Override
    public List<CommitterUserMapping> listForRepository(String repositoryName) {
        Preconditions.checkArgument((repositoryName != null ? 1 : 0) != 0, (Object)"repositoryName cannot be null");
        return this.listFor(null, repositoryName);
    }

    @Override
    public List<CommitterUserMapping> listForUserAndRepository(String userName, String repositoryName) {
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0, (Object)"userName cannot be null");
        Preconditions.checkArgument((repositoryName != null ? 1 : 0) != 0, (Object)"repositoryName cannot be null");
        return this.listFor(userName, repositoryName);
    }

    @Override
    public void renameUser(String oldName, String newName) {
        this.deleteForUser(newName);
        Query q2 = this.session().createQuery("update CommitterUserMapping set userName = :newName where userName = :oldName");
        q2.setString("oldName", UserManager.USERNAME_NORMALIZATION.apply(oldName));
        q2.setString("newName", UserManager.USERNAME_NORMALIZATION.apply(newName));
        q2.executeUpdate();
    }

    private List<CommitterUserMapping> listFor(@Nullable String userName, @Nullable String repositoryName) {
        Criteria criteria = this.session().createCriteria(CommitterUserMapping.class);
        if (userName != null) {
            criteria.add((Criterion)Restrictions.eq((String)"userName", (Object)UserManager.USERNAME_NORMALIZATION.apply(userName)));
        }
        if (repositoryName != null) {
            criteria.add((Criterion)Restrictions.eq((String)"repositoryName", (Object)repositoryName));
        }
        criteria.addOrder(Order.asc((String)"userName"));
        criteria.addOrder(Order.asc((String)"repositoryName"));
        criteria.addOrder(Order.asc((String)"committerName"));
        return HibernateUtil.typedList(criteria);
    }

    @Override
    public CommitterUserMapping getByRepositoryAndCommitter(String repositoryName, String committerName) {
        Preconditions.checkArgument((repositoryName != null ? 1 : 0) != 0, (Object)"repositoryName cannot be null");
        Preconditions.checkArgument((committerName != null ? 1 : 0) != 0, (Object)"committerName cannot be null");
        return (CommitterUserMapping)this.session().createCriteria(CommitterUserMapping.class).add((Criterion)Restrictions.eq((String)"repositoryName", (Object)repositoryName)).add((Criterion)Restrictions.eq((String)"committerName", (Object)committerName).ignoreCase()).setFirstResult(0).setMaxResults(1).uniqueResult();
    }
}

