/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.model.manager;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.CommitterDisplayDetails;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.model.ImplicitCommitterUserMapper;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.model.manager.dao.CommitterUserMappingDAO;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.cenqua.fisheye.util.EmailUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.TriggersRemove;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="committerUserMappingManager")
@AvailableToPlugins(value=CommitterUserMappingManager.class)
public class CommitterUserMappingManagerImpl
implements CommitterUserMappingManager,
BeanFactoryAware {
    public static final String USER_COMMITTER_MAPPINGS_CACHE = "userCommitterMappings";
    private static final Logger log = Logs.loggerFor(CommitterUserMappingManagerImpl.class);
    @Autowired
    private UserManager userManager;
    @Autowired
    private RepositoryManager repositoryManager;
    @Autowired
    private CommitterUserMappingDAO committerUserMappingDAO;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    @Qualifier(value="feCacheManager")
    private CacheManager cacheManager;
    @Autowired
    private TxTemplate txTemplate;
    private CommitterUserMappingManager self = this;

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    private void assertArguments(String ... params) {
        for (String s2 : params) {
            if (!Strings.isNullOrEmpty((String)s2)) continue;
            throw new IllegalArgumentException("Cannot have null or empty arguments for functions in CommitterUserMappingManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TriggersRemove(cacheName={"userCommitterMappings"}, removeAll=true)
    public void addMapping(String userName, String rep, String committer) {
        this.assertArguments(userName, rep, committer);
        try {
            HibernateUtil.beginTransaction();
            CommitterUserMapping mapping = this.findByRepositoryAndCommitter(rep, committer);
            if (mapping == null) {
                mapping = new CommitterUserMapping(userName, rep, committer);
            } else {
                Logs.APP_LOG.debug((Object)("Overriding existing mapping [" + mapping + "] with " + userName));
                mapping.setUserName(userName);
            }
            this.committerUserMappingDAO.add(mapping);
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TriggersRemove(cacheName={"userCommitterMappings"}, removeAll=true)
    public boolean delete(String userName, String rep, String committer) {
        boolean result = false;
        this.assertArguments(userName, rep, committer);
        try {
            HibernateUtil.beginTransaction();
            CommitterUserMapping mapping = this.findByRepositoryAndCommitter(rep, committer);
            if (mapping != null && UserManager.USERNAME_NORMALIZATION.apply(userName).equals(UserManager.USERNAME_NORMALIZATION.apply(mapping.getUserName()))) {
                this.committerUserMappingDAO.delete(mapping);
            } else {
                Logs.APP_LOG.warn((Object)("Deletion of mapping [" + userName + " <-> " + rep + "/" + committer + "] requested, but existing mapping is [" + mapping + "]"));
            }
            HibernateUtil.commitTransaction();
            result = true;
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
        return result;
    }

    @Override
    @TriggersRemove(cacheName={"userCommitterMappings"}, removeAll=true)
    public boolean deleteAllForUser(String userName) {
        this.assertArguments(userName);
        boolean result = false;
        try {
            HibernateUtil.beginTransaction();
            this.committerUserMappingDAO.deleteForUser(userName);
            HibernateUtil.commitTransaction();
            result = true;
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TriggersRemove(cacheName={"userCommitterMappings"}, removeAll=true)
    public void updateMapping(CommitterUserMapping oldMapping, CommitterUserMapping newMapping) {
        this.assertArguments(newMapping.getUserName(), newMapping.getRepositoryName(), newMapping.getCommitterName(), oldMapping.getUserName(), oldMapping.getRepositoryName(), oldMapping.getCommitterName());
        try {
            HibernateUtil.beginTransaction();
            CommitterUserMapping mapping = this.findByRepositoryAndCommitter(oldMapping.getRepositoryName(), oldMapping.getCommitterName());
            if (oldMapping.equals(mapping)) {
                this.committerUserMappingDAO.delete(mapping);
            } else {
                Logs.APP_LOG.debug((Object)("Deletion of mapping [" + oldMapping.toString() + "] requested, but existing mapping is [" + mapping.toString() + "]"));
            }
            mapping = this.findByRepositoryAndCommitter(newMapping.getRepositoryName(), newMapping.getCommitterName());
            if (mapping == null) {
                mapping = newMapping;
            } else {
                Logs.APP_LOG.debug((Object)("Overriding existing mapping [" + mapping + "] with " + newMapping.getUserName()));
                mapping.setUserName(newMapping.getUserName());
            }
            this.committerUserMappingDAO.add(mapping);
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
    }

    @Override
    public boolean explicitMappingExists(String repository, String committer) throws DbException {
        return this.self.findByRepositoryAndCommitter(repository, committer) != null;
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public CommitterUserMapping findByRepositoryAndCommitter(String repositoryName, String committerName) {
        return this.committerUserMappingDAO.getByRepositoryAndCommitter(repositoryName, committerName);
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public List<CommitterUserMapping> findAll() throws DbException {
        return this.committerUserMappingDAO.list();
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public Multimap<String, String> getExplicitCommittersForUser(String userName) {
        List<CommitterUserMapping> committerUserMappings = this.committerUserMappingDAO.listForUser(userName);
        HashMultimap mappings = HashMultimap.create();
        for (CommitterUserMapping committerUserMapping : committerUserMappings) {
            mappings.put((Object)committerUserMapping.getRepositoryName(), (Object)committerUserMapping.getCommitterName());
        }
        return mappings;
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public Multimap<String, String> getExplicitCommittersForUser(FecruUser user) throws DbException {
        return this.self.getExplicitCommittersForUser(user != null ? user.getUsername() : null);
    }

    @Override
    public Multimap<String, String> getImplicitCommittersForUser(String userName) throws DbException {
        return this.self.getImplicitCommittersForUser(this.userManager.getLicensedUser(userName));
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public Multimap<String, String> getImplicitCommittersForUser(FecruUser user) throws DbException {
        if (user == null) {
            throw new IllegalArgumentException("Cannot call getImplicitCommittersForUser with null or empty arguments");
        }
        List<RepositoryHandle> reps = this.repositoryManager.getHandles();
        HashMultimap mappings = HashMultimap.create();
        for (RepositoryHandle rep : reps) {
            List<String> committers = this.self.getImplicitCommittersForUserInRep(rep.getName(), user);
            if (committers.isEmpty()) continue;
            mappings.putAll((Object)rep.getName(), committers);
        }
        return mappings;
    }

    @Override
    public Multimap<String, String> getAllCommittersForUser(String userName) throws DbException {
        if (Strings.isNullOrEmpty((String)userName)) {
            throw new IllegalArgumentException("Cannot call getAllCommittersForUser with null or empty userName");
        }
        FecruUser feUser = this.userManager.getLicensedUser(userName);
        if (feUser == null) {
            throw new IllegalArgumentException("cannot get committers for a non-existent Fisheye user [" + userName + "]");
        }
        return this.self.getAllCommittersForUser(feUser);
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public Multimap<String, String> getAllCommittersForUser(FecruUser user) throws DbException {
        if (user == null) {
            throw new IllegalArgumentException("Cannot call getAllCommittersForUser with null user");
        }
        List<RepositoryHandle> reps = this.repositoryManager.getHandles();
        Multimap<String, String> mappings = this.self.getExplicitCommittersForUser(user);
        for (RepositoryHandle rep : reps) {
            List<String> committers = this.self.getImplicitCommittersForUserInRep(rep.getName(), user);
            if (committers.isEmpty()) continue;
            mappings.putAll((Object)rep.getName(), committers);
        }
        return mappings;
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public FecruUser getUserForCommitter(String repositoryName, String committerName) throws DbException {
        if (Strings.isNullOrEmpty((String)committerName) || Strings.isNullOrEmpty((String)repositoryName)) {
            return null;
        }
        CommitterUserMapping mapping = this.self.findByRepositoryAndCommitter(repositoryName, committerName);
        if (mapping != null) {
            return this.userManager.getLicensedUser(mapping.getUserName());
        }
        FecruUser user = this.userManager.getLicensedUser(committerName);
        if (user != null) {
            return user;
        }
        return this.getImplicitUserForCommitter(committerName);
    }

    private FecruUser getImplicitUserForCommitter(String committer) {
        Optional emailMatch;
        Function isMatch = page -> {
            if (page.getSize() == 1 && page.isLastPage()) {
                FecruUser user = (FecruUser)page.getValues().iterator().next();
                return Optional.ofNullable(user);
            }
            return Optional.empty();
        };
        Optional usernameMatch = (Optional)isMatch.apply(this.userManager.searchUsers(UserSearchCriteria.create().username(committer).withPermissions(GlobalPermissionType.FISHEYE_USER), PageRequest.create((Integer)0, (Integer)1)));
        if (usernameMatch.isPresent()) {
            return (FecruUser)usernameMatch.get();
        }
        String extractedEmail = EmailUtil.extractEmail(committer);
        if (extractedEmail != null && (emailMatch = (Optional)isMatch.apply(this.userManager.searchUsers(UserSearchCriteria.create().email(extractedEmail).withPermissions(GlobalPermissionType.FISHEYE_USER), PageRequest.create((Integer)0, (Integer)1)))).isPresent()) {
            return (FecruUser)emailMatch.get();
        }
        return null;
    }

    @Override
    public List<String> getImplicitCommittersForUserInRep(String rep, String userName) throws DbException {
        return this.self.getImplicitCommittersForUserInRep(rep, this.userManager.getLicensedUser(userName));
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public List<String> getImplicitCommittersForUserInRep(String rep, FecruUser user) throws DbException {
        LinkedList<String> committers = new LinkedList<String>();
        if (user == null || Strings.isNullOrEmpty((String)rep)) {
            throw new IllegalArgumentException("Cannot call getImplicitCommittersForUserInRep with null or empty arguments");
        }
        RepositoryHandle repHandle = this.repositoryManager.getRepository(rep);
        if (repHandle != null) {
            try {
                Predicate matcher = Predicates.and(ImplicitCommitterUserMapper.byUser(user), (Predicate)new NoMappingExists(rep));
                Set<String> allAuthors = repHandle.acquireEngine().getRevisionCache().getAllAuthors();
                Iterables.addAll(committers, (Iterable)Iterables.filter(allAuthors, (Predicate)matcher));
            }
            catch (RepositoryHandle.StateException stateException) {
                // empty catch block
            }
        }
        Collections.sort(committers, String.CASE_INSENSITIVE_ORDER);
        return committers;
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public List<String> getExplicitCommittersForUserInRep(String rep, String userName) throws DbException {
        List<CommitterUserMapping> committerUserMappings = this.committerUserMappingDAO.listForUserAndRepository(userName, rep);
        return ImmutableList.copyOf((Iterable)Iterables.transform(committerUserMappings, (Function)new Function<CommitterUserMapping, String>(){

            public String apply(CommitterUserMapping committerUserMapping) {
                return committerUserMapping.getCommitterName();
            }
        }));
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public List<String> getAllCommittersForUserInRep(String rep, String userName) throws DbException {
        return this.self.getAllCommittersForUserInRep(rep, this.userManager.getLicensedUser(userName));
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public List<String> getAllCommittersForUserInRep(String rep, FecruUser user) throws DbException {
        ArrayList<String> allCommitters = new ArrayList<String>();
        if (user != null) {
            allCommitters.addAll(this.self.getExplicitCommittersForUserInRep(rep, user.getUsername()));
            allCommitters.addAll(this.self.getImplicitCommittersForUserInRep(rep, user));
        }
        return allCommitters;
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public List<CommitterDisplayDetails> constructUserListFromCommitters(String rep, List<String> committerNames) throws DbException {
        ArrayList<CommitterDisplayDetails> userList = new ArrayList<CommitterDisplayDetails>();
        for (String committer : committerNames) {
            FecruUser user = this.self.getUserForCommitter(rep, committer);
            if (user != null) {
                userList.add(new CommitterDisplayDetails(user.getDisplayName(), committer));
                continue;
            }
            userList.add(new CommitterDisplayDetails(committer, committer));
        }
        Collections.sort(userList);
        return userList;
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public Set<FecruUser> getUsersForCommittersInRep(String rep, List<String> committerNames) throws DbException {
        TreeSet users = Sets.newTreeSet(FecruUser.DISPLAYNAME_COMPARATOR);
        for (String committer : committerNames) {
            FecruUser user = this.getUserForCommitter(rep, committer);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    @Cacheable(cacheName="userCommitterMappings")
    public Multimap<String, String> getDisplayNameToCommitterMap(String repname) throws DbException {
        List<CommitterUserMapping> committerUserMappings = repname != null ? this.committerUserMappingDAO.listForRepository(repname) : this.committerUserMappingDAO.list();
        HashMultimap explicitUsernameToCommitter = HashMultimap.create();
        for (CommitterUserMapping element : committerUserMappings) {
            explicitUsernameToCommitter.put((Object)element.getUserName(), (Object)element.getCommitterName());
        }
        Collection explicitlyMappedCommitters = explicitUsernameToCommitter.values();
        HashMultimap result = HashMultimap.create();
        for (FecruUser user : this.userManager.getLicensedUsers()) {
            String displayName = user.getDisplayName();
            if (explicitUsernameToCommitter.containsKey((Object)user.getUsername())) {
                result.putAll((Object)displayName, (Iterable)explicitUsernameToCommitter.get((Object)user.getUsername()));
            }
            if (explicitlyMappedCommitters.contains(user.getUsername())) continue;
            result.put((Object)displayName, (Object)user.getUsername());
        }
        return result;
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent event) {
        this.txTemplate.execute(tx -> {
            this.committerUserMappingDAO.renameUser(event.getOldUsername(), event.getNewUsername());
            return null;
        });
    }

    @EventListener
    public void onUserListChanged(UserListChangedEvent event) {
        log.debug((Object)("Invalidating committer mapping cache due to " + event));
        this.cacheManager.getCache(USER_COMMITTER_MAPPINGS_CACHE).removeAll();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Object bean = beanFactory.getBean("committerUserMappingManager");
        this.self = (CommitterUserMappingManager)bean;
    }

    class NoMappingExists
    implements Predicate<String> {
        private final String rep;

        NoMappingExists(String rep) {
            this.rep = rep;
        }

        public boolean apply(String author) {
            return !CommitterUserMappingManagerImpl.this.self.explicitMappingExists(this.rep, author);
        }
    }
}

