/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.model;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.util.concurrent.LazyReference;
import com.cenqua.fisheye.util.EmailUtil;
import com.google.common.base.Predicate;
import org.apache.commons.lang.StringUtils;

public class ImplicitCommitterUserMapper
implements Predicate<FecruUser> {
    private final String name;
    private final LazyReference<String> email = new LazyReference<String>(){

        protected String create() {
            return EmailUtil.extractEmail(ImplicitCommitterUserMapper.this.name);
        }
    };

    public ImplicitCommitterUserMapper(String name) {
        this.name = name;
    }

    public boolean apply(FecruUser user) {
        if (user == null) {
            return false;
        }
        if (user.getUsername().equalsIgnoreCase(this.name)) {
            return true;
        }
        String userEmail = user.getEmail();
        if (StringUtils.isBlank((String)userEmail)) {
            return false;
        }
        String committerEmail = (String)this.email.get();
        return StringUtils.isNotBlank((String)committerEmail) && committerEmail.equalsIgnoreCase(userEmail);
    }

    public static Predicate<String> byUser(FecruUser user) {
        return new ForUser(user);
    }

    static class ForUser
    implements Predicate<String> {
        private final FecruUser user;

        ForUser(FecruUser user) {
            this.user = user;
        }

        public boolean apply(String input) {
            return new ImplicitCommitterUserMapper(input).apply(this.user);
        }
    }
}

