/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.model;

import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.base.Objects;
import java.io.Serializable;

public class ContentRoot
implements Serializable {
    private String repName;
    private String path;
    private Integer id;
    private Project project;

    public ContentRoot(Project project, String repName, String path) {
        this.project = project;
        this.setRepName(repName);
        this.setPath(path);
    }

    ContentRoot() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getRepName() {
        return this.repName;
    }

    public RepositoryHandle getRepHandle() {
        return AppConfig.getsConfig().getRepositoryManager().getRepository(this.repName);
    }

    public void setRepName(String repName) {
        ModelUtils.ensureNotNullOrEmpty("Content root repository names", repName);
        this.repName = repName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        ModelUtils.ensureNotNullOrEmpty("Content root paths", path);
        this.path = path;
    }

    public boolean isWholeRepository() {
        return this.getPath().equals("/");
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ContentRoot that = (ContentRoot)o2;
        return Objects.equal((Object)this.repName, (Object)that.repName) && Objects.equal((Object)this.path, (Object)that.path) && Objects.equal((Object)this.project, (Object)that.project);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.repName, this.path, this.project});
    }
}

