/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.model;

import com.cenqua.crucible.model.ModelUtils;
import com.cenqua.fisheye.user.UserManager;
import java.util.Locale;

public class CommitterUserMapping {
    public static final String COMMITTER_NAME = "committerName";
    public static final String USER_NAME = "userName";
    public static final String REPOSITORY_NAME = "repositoryName";
    private String committerName;
    private String userName;
    private String repositoryName;

    public CommitterUserMapping(String userName, String rep, String committer) {
        this.setUserName(userName);
        this.setRepositoryName(rep);
        this.setCommitterName(committer);
    }

    CommitterUserMapping() {
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        ModelUtils.ensureNotNullOrEmpty("Repository names", repositoryName);
        this.repositoryName = repositoryName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = UserManager.USERNAME_NORMALIZATION.apply(userName);
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public void setCommitterName(String committerName) {
        ModelUtils.ensureNotNullOrEmpty("Commiter names", committerName);
        this.committerName = committerName;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof CommitterUserMapping)) {
            return false;
        }
        CommitterUserMapping other = (CommitterUserMapping)o2;
        return this.committerName == null ? other.committerName == null : (this.committerName.equalsIgnoreCase(other.committerName) && this.repositoryName == null ? other.repositoryName == null : this.repositoryName.equals(other.repositoryName));
    }

    public int hashCode() {
        int value = this.committerName.toLowerCase(Locale.US).hashCode();
        value = value * 23 + this.repositoryName.hashCode();
        return value;
    }

    public String toString() {
        return this.userName + " <-> " + this.repositoryName + "/" + this.committerName;
    }
}

