/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.mail;

import com.atlassian.fisheye.spi.data.MailMessageData;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.SmtpType;
import com.cenqua.fisheye.io.NullOutputStream;
import com.cenqua.fisheye.logging.Logs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mailer")
public class Mailer {
    private static final Pattern CUSTOM_SUBJECT_FORMAT = Pattern.compile("^Subject: *([^\\n\\r]*)(\\n\\r|\\r\\n|\\r|\\n){2}(.*)$", 32);
    private static final int SUBJECT_GROUP = 1;
    private static final int BODY_GROUP = 3;
    private Session session;
    private InternetAddress defaultFrom;
    private boolean useFrom;
    private boolean debug;

    protected Mailer() {
    }

    @Autowired
    public Mailer(RootConfig rootConfig) {
        this.reload(rootConfig.getConfig().getSmtp());
    }

    Mailer(SmtpType cfg) {
        this.reload(cfg);
    }

    private Properties getDefaultProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        return props;
    }

    public synchronized void reload(final SmtpType cfg) {
        this.session = null;
        Logs.Warnings.warnMailerNotConfiguredJustOnce = true;
        if (cfg == null) {
            Logs.MAIL_LOG.info((Object)"Mail system not configured.");
            return;
        }
        Logs.MAIL_LOG.info((Object)"Starting mail system...");
        boolean bl = this.debug = cfg.isSetDebug() && cfg.getDebug();
        if (this.debug) {
            Logs.enableMailDebugLogging();
        } else {
            Logs.disableMailDebugLogging();
        }
        Properties props = new Properties(this.getDefaultProperties());
        props.setProperty("mail.smtp.host", cfg.getHost());
        props.put("mail.smtp.starttls.enable", String.valueOf(cfg.getStarttls()));
        Logs.MAIL_LOG.debug((Object)("mail.smtp.host = " + cfg.getHost()));
        Logs.MAIL_LOG.debug((Object)("mail.smtp.starttls.enable = " + String.valueOf(cfg.getStarttls())));
        if (cfg.isSetPort()) {
            props.setProperty("mail.smtp.port", cfg.getPort().toString());
            Logs.MAIL_LOG.debug((Object)("mail.smtp.port = " + cfg.getPort()));
        }
        try {
            props.setProperty("mail.from", cfg.getFrom());
            Logs.MAIL_LOG.debug((Object)("mail.from = " + cfg.getFrom()));
            this.defaultFrom = new InternetAddress(cfg.getFrom());
            this.useFrom = cfg.getSendEmailsAsActioner();
        }
        catch (AddressException e2) {
            Logs.MAIL_LOG.warn((Object)("Invalid SMTP From address '" + cfg.getFrom() + "': " + e2.getMessage()));
        }
        if (cfg.isSetConnectionTimeout()) {
            props.setProperty("mail.smtp.connectiontimeout", cfg.getConnectionTimeout().multiply(BigInteger.valueOf(1000L)).toString());
            Logs.MAIL_LOG.debug((Object)("mail.smtp.connectiontimeout = " + cfg.getConnectionTimeout().multiply(BigInteger.valueOf(1000L)).toString()));
        }
        if (cfg.isSetTimeout()) {
            props.setProperty("mail.smtp.timeout", cfg.getTimeout().multiply(BigInteger.valueOf(1000L)).toString());
            Logs.MAIL_LOG.debug((Object)("mail.smtp.timeout = " + cfg.getTimeout().multiply(BigInteger.valueOf(1000L)).toString()));
        }
        if (cfg.isSetUsername()) {
            final String password = cfg.isSetPassword() ? cfg.getPassword() : "";
            props.put("mail.smtp.auth", "true");
            Logs.MAIL_LOG.debug((Object)"mail.smtp.auth = true");
            Logs.MAIL_LOG.debug((Object)(" username = " + cfg.getUsername()));
            Logs.MAIL_LOG.debug((Object)" password = *******");
            this.session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(cfg.getUsername(), password);
                }
            });
        } else {
            this.session = Session.getInstance((Properties)props);
        }
        if (this.debug) {
            PrintStream debug = new PrintStream(new NullOutputStream(){
                private ByteArrayOutputStream baos = new ByteArrayOutputStream();

                @Override
                public synchronized void write(int i2) throws IOException {
                    if (i2 == 10 || i2 == 13) {
                        this.log();
                    } else {
                        this.baos.write(i2);
                    }
                }

                @Override
                public void close() throws IOException {
                    this.log();
                    super.close();
                }

                private void log() {
                    if (this.baos.size() > 0) {
                        Logs.MAIL_LOG.debug((Object)new String(this.baos.toByteArray()));
                        this.baos.reset();
                    }
                }
            });
            this.session.setDebug(true);
            this.session.setDebugOut(debug);
        }
        Logs.MAIL_LOG.info((Object)"Mail system started.");
    }

    public synchronized boolean isConfigured() {
        return this.session != null;
    }

    public boolean getUseFrom() {
        return this.useFrom;
    }

    public void setUseFrom(boolean useFrom) {
        this.useFrom = useFrom;
    }

    public boolean isDebug() {
        return this.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(MailMessageData message) {
        Session sess;
        Mailer mailer = this;
        synchronized (mailer) {
            if (this.session == null) {
                if (Logs.Warnings.warnMailerNotConfiguredJustOnce) {
                    Logs.Warnings.warnMailerNotConfiguredJustOnce = false;
                    Logs.MAIL_LOG.info((Object)"Tried to send an email, but SMTP not configured.");
                }
                return false;
            }
            sess = this.session;
        }
        try {
            return this.send(sess, message, this.defaultFrom);
        }
        catch (Exception e2) {
            Logs.MAIL_LOG.error((Object)"problem sending email", (Throwable)e2);
            return false;
        }
    }

    boolean send(Session session, MailMessageData message, InternetAddress defaultFrom) throws MessagingException {
        if (message.getRecipients().isEmpty()) {
            Logs.MAIL_LOG.info((Object)("No recipients specified for email with subject: " + message.getSubject()));
            return false;
        }
        MimeMessage email = new MimeMessage(session);
        this.setupRecipients(email, message);
        this.setupHeaders(email, message);
        email.setSentDate(new Date());
        this.setupSubjectAndBody(email, message);
        InternetAddress fromAddr = this.getEffectiveFromAddress(email, message, defaultFrom);
        if (fromAddr != null) {
            email.setFrom((Address)fromAddr);
        }
        Transport.send((Message)email);
        Logs.MAIL_LOG.info((Object)("Sent: to=" + Arrays.asList(email.getAllRecipients()) + ",from=" + Arrays.asList(email.getFrom()) + ",subject=''" + email.getSubject() + "'"));
        return true;
    }

    private void setupHeaders(MimeMessage email, MailMessageData message) throws MessagingException {
        email.setHeader("X-Mailer", "Atlassian-" + AppConfig.getProductName().replaceAll("\\s", "-"));
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            email.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setupRecipients(MimeMessage email, MailMessageData message) throws MessagingException {
        for (String addr : message.getRecipients()) {
            email.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)addr, (boolean)false));
        }
    }

    private void setupSubjectAndBody(MimeMessage email, MailMessageData message) throws MessagingException {
        BodyHeaderParseResult result;
        email.setSubject(this.cleanSubject(message.getSubject()), message.getCharset());
        if (message.getMultipartContent() != null) {
            email.setContent(message.getMultipartContent());
        } else {
            email.setContent((Object)message.getBodyText(), message.getContentType());
        }
        if (message.isAllowCustomBodyHeader() && (result = this.parseCustomBodyHeaders(message)).hasSubjectHeader()) {
            email.setSubject(this.cleanSubject(result.getSubject()), message.getCharset());
            email.setContent((Object)result.getBody(), message.getContentType());
        }
    }

    private String cleanSubject(String subject) {
        return subject.replace('\n', ' ').replace('\r', ' ');
    }

    private BodyHeaderParseResult parseCustomBodyHeaders(MailMessageData message) {
        Matcher matcher = CUSTOM_SUBJECT_FORMAT.matcher(message.getBodyText());
        String customSubject = message.getSubject();
        String restofBody = message.getBodyText();
        boolean hasCustomSubjectHeader = matcher.matches();
        if (hasCustomSubjectHeader) {
            customSubject = matcher.group(1);
            restofBody = matcher.group(3);
        }
        return new BodyHeaderParseResult(customSubject, restofBody, hasCustomSubjectHeader);
    }

    private InternetAddress getEffectiveFromAddress(MimeMessage email, MailMessageData message, InternetAddress defaultFrom) throws MessagingException {
        InternetAddress addr = defaultFrom;
        String from = message.getFrom();
        try {
            if (from != null) {
                addr = new InternetAddress(from);
                Logs.MAIL_LOG.debug((Object)("Using from address: '" + from + "'"));
            }
        }
        catch (AddressException e2) {
            Logs.MAIL_LOG.debug((Object)("Invalid user email '" + from + "' - using server email as from address."));
            Logs.APP_LOG.error((Object)("Invalid user email '" + from + "' - using server email as from address."));
        }
        return addr == null ? addr : this.maybeSetDisplayName(message, addr);
    }

    private InternetAddress maybeSetDisplayName(MailMessageData message, InternetAddress fromAddr) {
        String fromDisplayName = message.getFromDisplayName();
        if (fromDisplayName != null) {
            fromAddr = (InternetAddress)fromAddr.clone();
            try {
                fromAddr.setPersonal(fromDisplayName, "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                Logs.APP_LOG.warn((Object)"Character encoding problem setting personal from name.", (Throwable)e2);
            }
        }
        return fromAddr;
    }

    private static class BodyHeaderParseResult {
        private String subject;
        private String body;
        private boolean hasHeader = false;

        public BodyHeaderParseResult(String subject, String body, boolean hasHeader) {
            this.subject = subject;
            this.body = body;
            this.hasHeader = hasHeader;
        }

        public String getSubject() {
            return this.subject;
        }

        String getBody() {
            return this.body;
        }

        boolean hasSubjectHeader() {
            return this.hasHeader;
        }
    }
}

