/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.searcher;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;

public class MultiRepositoryIndexReader
extends MultiReader {
    private final Map<IndexReader, RepositoryEngine> enginesForReaders;

    public MultiRepositoryIndexReader(Map<IndexReader, RepositoryEngine> enginesForReaders) {
        super((IndexReader[])Iterables.toArray(enginesForReaders.keySet(), IndexReader.class));
        this.enginesForReaders = ImmutableMap.copyOf(enginesForReaders);
    }

    public RepositoryEngine getRepositoryEngineForDoc(int docId) {
        int readerIdx = this.readerIndex(docId);
        IndexReader docReader = this.subReaders[readerIdx];
        return this.enginesForReaders.get(docReader);
    }

    protected synchronized void doClose() throws IOException {
        IOException exception = null;
        for (IndexReader subReader : this.subReaders) {
            try {
                subReader.decRef();
            }
            catch (IOException e2) {
                Logs.APP_LOG.warn((Object)("Error closing reader - " + e2.getMessage()), (Throwable)e2);
                if (exception != null) continue;
                exception = e2;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

