/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.join;

import com.cenqua.fisheye.lucene.AbstractBitsetQuery;
import com.cenqua.fisheye.lucene.join.BitSetRightJoinEnum;
import com.cenqua.fisheye.lucene.join.DocumentRightJoinEnum;
import com.cenqua.fisheye.lucene.join.LeftJoin;
import com.cenqua.fisheye.lucene.join.RightJoinEnum;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;

public class LeftJoinQuery
extends AbstractBitsetQuery {
    private final LeftJoin leftJoin;

    public LeftJoinQuery(String leftField, IndexReader rightReader, String rightField, BitSet rightDocIds) {
        this(leftField, LeftJoinQuery.makeRightEnum(rightDocIds, rightReader, rightField));
    }

    public LeftJoinQuery(String leftField, RightJoinEnum rightEnum) {
        this.leftJoin = new LeftJoin(leftField, rightEnum);
        this.score = 1.0f;
    }

    public static RightJoinEnum makeRightEnum(BitSet rightDocIds, IndexReader rightReader, String rightField) {
        int thresh = 20000;
        RightJoinEnum rightEnum = rightDocIds.cardinality() < thresh ? new DocumentRightJoinEnum(rightReader, rightField, rightDocIds) : new BitSetRightJoinEnum(rightReader, rightField, rightDocIds);
        return rightEnum;
    }

    @Override
    protected BitSet computeBitset(IndexReader reader) throws IOException {
        return this.leftJoin.computeResult(reader);
    }

    @Override
    protected String getFilterExplanation() {
        return "join";
    }

    public String toString(String field) {
        return "join";
    }
}

