/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.join;

import com.cenqua.fisheye.lucene.join.RightJoinEnum;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;

public class DocumentRightJoinEnum
implements RightJoinEnum {
    private final String rightField;
    private final BitSet rightDocIds;
    private final IndexReader rightReader;
    private String[] currentVals;
    private int currentVal;
    private Term currentRightTerm;
    private int s_loop1;
    private int docid;

    public DocumentRightJoinEnum(IndexReader rightReader, String rightField, BitSet rightDocIds) {
        this.rightField = rightField;
        this.rightDocIds = rightDocIds;
        this.rightReader = rightReader;
    }

    @Override
    public void reset() throws IOException {
        this.currentRightTerm = null;
        this.docid = this.rightDocIds.nextSetBit(0);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.currentVals != null && this.currentVal < this.currentVals.length) {
            this.currentRightTerm = new Term(this.rightField, this.currentVals[this.currentVal++]);
            return true;
        }
        if (this.docid >= 0) {
            ++this.s_loop1;
            Document doc = this.rightReader.document(this.docid);
            this.docid = this.rightDocIds.nextSetBit(this.docid + 1);
            this.currentVals = doc.getValues(this.rightField);
            this.currentVal = 0;
            if (this.currentVals != null && this.currentVals.length > 0) {
                this.currentRightTerm = new Term(this.rightField, this.currentVals[this.currentVal++]);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Term term() {
        return this.currentRightTerm;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String describe() {
        return "doc right-enum [#loops=" + this.s_loop1 + " bitset.card=" + this.rightDocIds.cardinality() + "]";
    }
}

