/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.join;

import com.cenqua.fisheye.lucene.join.RightJoinEnum;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class BitSetRightJoinEnum
implements RightJoinEnum {
    private final String rightField;
    private final BitSet rightDocIds;
    private final int firstRightDocId;
    private final IndexReader rightReader;
    private TermDocs rightTD;
    private TermEnum rightTE;
    private Term currentRightTerm;
    private int s_loop1;

    public BitSetRightJoinEnum(IndexReader rightReader, String rightField, BitSet rightDocIds) {
        this.rightField = rightField;
        this.rightDocIds = rightDocIds;
        this.firstRightDocId = rightDocIds.nextSetBit(0);
        this.rightReader = rightReader;
    }

    @Override
    public void reset() throws IOException {
        this.s_loop1 = 0;
        this.currentRightTerm = new Term(this.rightField, "");
        this.rightTE = this.rightReader.terms(this.currentRightTerm);
        this.rightTD = this.rightReader.termDocs();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.firstRightDocId == -1) {
            // empty if block
        }
        Term t2 = this.rightTE.term();
        while (t2 != null && this.rightField.equals(t2.field())) {
            block7: {
                int b2;
                int a2;
                ++this.s_loop1;
                this.rightTD.seek(this.rightTE);
                if (this.rightTD.skipTo(this.firstRightDocId) && (a2 = this.rightDocIds.nextSetBit(b2 = this.rightTD.doc())) >= 0) {
                    block8: {
                        while (true) {
                            if (a2 > b2) {
                                if (this.rightTD.skipTo(a2)) {
                                    b2 = this.rightTD.doc();
                                    continue;
                                }
                                break block7;
                            }
                            if (a2 >= b2) break block8;
                            a2 = this.rightDocIds.nextSetBit(b2);
                            if (a2 == -1) break;
                        }
                        break block7;
                    }
                    this.currentRightTerm = t2;
                    this.rightTE.next();
                    return true;
                }
            }
            if (!this.rightTE.next()) {
                return false;
            }
            t2 = this.rightTE.term();
        }
        return false;
    }

    @Override
    public Term term() {
        return this.currentRightTerm;
    }

    @Override
    public void close() throws IOException {
        this.rightTD.close();
        this.rightTE.close();
    }

    @Override
    public String describe() {
        return "bitset right-enum [#loops=" + this.s_loop1 + " bitset.card=" + this.rightDocIds.cardinality() + "]";
    }
}

