/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.filenames;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class FilenameFilter
extends TokenFilter {
    private final boolean replace;
    private String baseFilename;
    private final CharTermAttribute termAttribute;

    public FilenameFilter(TokenStream input, boolean replace) {
        super(input);
        this.replace = replace;
        this.termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.replace) {
            return this.incrementWithReplace();
        }
        return this.incrementWithAddition();
    }

    private boolean incrementWithAddition() throws IOException {
        if (this.baseFilename == null) {
            String basename;
            String filename;
            boolean hasMore = this.input.incrementToken();
            if (hasMore && !(filename = this.termAttribute.toString()).equals(basename = FilenameUtils.getBaseName((String)filename))) {
                this.baseFilename = basename;
            }
            return hasMore;
        }
        this.termAttribute.setEmpty().append(this.baseFilename);
        this.baseFilename = null;
        return true;
    }

    private boolean incrementWithReplace() throws IOException {
        boolean hasMore = this.input.incrementToken();
        if (hasMore) {
            String filename = this.termAttribute.toString();
            String basename = FilenameUtils.getBaseName((String)filename);
            this.termAttribute.setEmpty().append(basename);
        }
        return hasMore;
    }

    public boolean isReplace() {
        return this.replace;
    }
}

