/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.camelcases;

import com.cenqua.fisheye.lucene.camelcases.Subword;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CamelCaseTokenizer {
    private static final Pattern SUBWORDS = Pattern.compile("\\.?(?:[\\d]+|\\p{Alpha}+)");
    private static final Pattern CAMELCASES = Pattern.compile("\\.?\\p{Upper}?\\p{Lower}+");

    public LinkedList<Subword> findSubWords(String word) {
        return this.breakCamelCaseSubwords(this.breakAlphanumericSubwords(word));
    }

    private LinkedList<Subword> breakAlphanumericSubwords(String word) {
        LinkedList<Subword> subwords = new LinkedList<Subword>();
        Matcher matcher = SUBWORDS.matcher(word);
        while (matcher.find()) {
            subwords.add(new Subword(matcher.start(), matcher.end(), matcher.group()));
        }
        return subwords;
    }

    private LinkedList<Subword> breakCamelCaseSubwords(LinkedList<Subword> subwords) {
        ListIterator<Subword> i2 = subwords.listIterator();
        while (i2.hasNext()) {
            Subword subword = (Subword)i2.next();
            String text = subword.getText();
            Matcher matcher = CAMELCASES.matcher(text);
            if (matcher.matches()) continue;
            matcher.reset();
            if (!matcher.find()) continue;
            String match = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            if (start == 0) {
                i2.set(new Subword(subword.getStart(), subword.getStart() + end, match));
                i2.add(new Subword(subword.getStart() + end, subword.getEnd(), text.substring(end)));
            } else {
                i2.set(new Subword(subword.getStart(), subword.getStart() + start, text.substring(0, start)));
                i2.add(new Subword(subword.getStart() + start, subword.getEnd(), text.substring(start)));
            }
            i2.previous();
        }
        return subwords;
    }
}

