/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.camelcases;

import com.cenqua.fisheye.lucene.camelcases.CamelCaseTokenizer;
import com.cenqua.fisheye.lucene.camelcases.Subword;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

class CamelCaseFilter
extends TokenFilter {
    private final CamelCaseTokenizer tokenizer = new CamelCaseTokenizer();
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private Iterator<Subword> subwordIterator;
    private int startOffset;

    protected CamelCaseFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        if (this.subwordIterator != null && this.subwordIterator.hasNext()) {
            return this.incrementSubword();
        }
        this.subwordIterator = null;
        return this.incrementToNextToken();
    }

    private boolean incrementSubword() {
        Subword subword = this.subwordIterator.next();
        this.termAttribute.setEmpty().append(subword.getText());
        this.offsetAttribute.setOffset(this.startOffset + subword.getStart(), this.startOffset + subword.getEnd());
        return true;
    }

    private boolean incrementToNextToken() throws IOException {
        boolean hasNext = this.input.incrementToken();
        if (hasNext) {
            String nextWord = this.termAttribute.toString();
            this.startOffset = this.offsetAttribute.startOffset();
            LinkedList<Subword> subwords = this.getSubWords(nextWord);
            if (!subwords.isEmpty()) {
                this.subwordIterator = subwords.iterator();
                return this.incrementSubword();
            }
            return false;
        }
        return hasNext;
    }

    protected LinkedList<Subword> getSubWords(String nextWord) {
        return this.tokenizer.findSubWords(nextWord);
    }
}

