/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene.camelcases;

import com.cenqua.fisheye.lucene.camelcases.CamelCaseFilter;
import com.cenqua.fisheye.lucene.camelcases.Subword;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.analysis.TokenStream;

final class CamelCaseCombinationFilter
extends CamelCaseFilter {
    protected CamelCaseCombinationFilter(TokenStream input) {
        super(input);
    }

    @Override
    protected LinkedList<Subword> getSubWords(String nextWord) {
        LinkedList<Subword> subWords = super.getSubWords(nextWord);
        LinkedList<Subword> combinations = new LinkedList<Subword>();
        ListIterator i2 = subWords.listIterator();
        while (i2.hasNext()) {
            Subword subword1 = (Subword)i2.next();
            if (!i2.hasNext()) break;
            StringBuilder sb = new StringBuilder(subword1.getText());
            int start = subword1.getStart();
            int increment = 0;
            while (i2.hasNext()) {
                Subword subword2 = (Subword)i2.next();
                int end = subword2.getEnd();
                sb.append(subword2.getText());
                combinations.add(new Subword(start, end, sb.toString()));
                ++increment;
            }
            while (increment-- > 0 && i2.hasPrevious()) {
                i2.previous();
            }
        }
        return combinations;
    }
}

