/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class PathAnalyzer
extends Analyzer {
    public TokenStream tokenStream(String fieldName, Reader reader) {
        try {
            return new PathTokenizer(reader);
        }
        catch (IOException e2) {
            Logs.APP_LOG.debug((Object)"Error in PathAnalyzer", (Throwable)e2);
            return null;
        }
    }

    public static final class PathTokenizer
    extends Tokenizer {
        Path path;
        int index = -1;
        final CharTermAttribute token;

        public PathTokenizer(Reader reader) throws IOException {
            super(reader);
            this.path = new Path(IOHelper.copyReaderToString(reader));
            this.token = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        }

        public boolean incrementToken() throws IOException {
            if (this.path == null || this.index >= this.path.numComponents()) {
                return false;
            }
            if (this.index < 0) {
                this.index = 0;
                this.token.setEmpty().append("/");
                return true;
            }
            String comp = this.path.getComponent(this.index);
            this.token.setEmpty().append(comp);
            ++this.index;
            return true;
        }

        public void close() throws IOException {
            super.close();
            this.path = null;
        }
    }
}

