/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.lucene.LuceneConnection;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public enum LuceneIndexes implements LuceneConnection.IndexConfig
{
    METADATA_OBSOLETE(0, true),
    CONTENT(1),
    DIFFTEXT(2),
    CHANGESET_OBSOLETE(3, true),
    QUICKNAV_OBSOLETE(4, true);

    public static final long METADATA_VERSION = 29L;
    private final int index;
    private final boolean obsolete;

    private LuceneIndexes(int i2) {
        this(i2, false);
    }

    private LuceneIndexes(int i2, boolean obsolete) {
        this.index = i2;
        this.obsolete = obsolete;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public static LuceneIndexes[] activeValues() {
        return LuceneIndexes.filteredValues(new Predicate<LuceneIndexes>(){

            public boolean apply(@Nullable LuceneIndexes input) {
                return input != null && !input.isObsolete();
            }
        });
    }

    public static LuceneIndexes[] obsoleteValues() {
        return LuceneIndexes.filteredValues(new Predicate<LuceneIndexes>(){

            public boolean apply(@Nullable LuceneIndexes input) {
                return input != null && input.isObsolete();
            }
        });
    }

    private static LuceneIndexes[] filteredValues(Predicate<LuceneIndexes> p2) {
        Collection active = Collections2.filter(Arrays.asList(LuceneIndexes.values()), p2);
        return active.toArray(new LuceneIndexes[active.size()]);
    }
}

