/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.NonOrderedCollector;
import com.cenqua.fisheye.lucene.TermDocVistor;
import com.cenqua.fisheye.lucene.TermVisitor;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.DateHelper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class LuceneHelper {
    public static final String DATE_TIME_MS = "dTimeMillis";
    public static final String LAST_UPDATE_HRS = "lastUpdateHours";
    public static final Sort SORT_TOWARDS_FUTURE = new Sort(new SortField[]{new SortField("dTimeMillis", 6, false)});
    public static final Sort SORT_TOWARDS_PAST = new Sort(new SortField[]{new SortField("dTimeMillis", 6, true)});
    public static final int MAX_HIT_COUNT = Integer.MAX_VALUE;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().appendCenturyOfEra(2, 2).appendYearOfCentury(2, 2).appendMonthOfYear(2).appendDayOfMonth(2).appendHourOfDay(2).appendMinuteOfHour(2).appendSecondOfMinute(2).appendMillisOfSecond(3).toFormatter().withZone(DateTimeZone.forID((String)"GMT"));
    private static final String INDEXED_DATE_FORMAT = "yyyyMMddHHmmssSSS";
    private static final Supplier<FastDateFormat> fastDateFormat = Suppliers.memoize((Supplier)new Supplier<FastDateFormat>(){

        public FastDateFormat get() {
            return FastDateFormat.getInstance((String)LuceneHelper.INDEXED_DATE_FORMAT, (TimeZone)DateHelper.GMT);
        }
    });

    public static Set<String> findTerms(IndexReader reader, String field) throws DbException {
        final HashSet<String> terms = new HashSet<String>();
        TermVisitor.visitTermDocs(reader, field, new TermVisitor.Visitor(){

            @Override
            public boolean visit(Term t2) {
                terms.add(t2.text());
                return true;
            }
        });
        return terms;
    }

    public static NumericField lastModifiedField(Date date) {
        return new NumericField(LAST_UPDATE_HRS, Field.Store.NO, true).setIntValue(TimeZoneVariables.reduceMillisToHours(date.getTime()));
    }

    public static boolean existsMatchingDocuments(IndexSearcher searcher, Query q2) throws IOException {
        return LuceneHelper.countMatchingDocuments(searcher, q2) > 0;
    }

    public static int countMatchingDocuments(IndexSearcher searcher, Query q2) throws IOException {
        TotalHitCountCollector c2 = new TotalHitCountCollector();
        searcher.search(q2, null, (Collector)c2);
        return c2.getTotalHits();
    }

    public static BitSet collectMatchingDocuments(IndexSearcher searcher, Query q2, Filter f2) throws IOException {
        BitSet bits = new BitSet(searcher.maxDoc());
        LuceneHelper.collectMatchingDocuments(searcher, q2, f2, bits);
        return bits;
    }

    public static void collectMatchingDocuments(IndexSearcher searcher, Query q2, Filter f2, final BitSet bits) throws IOException {
        searcher.search(q2, f2, (Collector)new NonOrderedCollector(){

            @Override
            public void collectDocId(int docid) {
                bits.set(docid);
            }
        });
    }

    public static void collectSearchResultsInBatches(IndexSearcher indexSearcher, Query query, @Nullable Sort sort, @Nullable Integer limit, int batchSize, BatchCollector collector) throws IOException {
        int readLimit;
        TopDocs hits = null;
        int read = 0;
        int n2 = readLimit = limit != null ? limit : Integer.MAX_VALUE;
        while (read < readLimit) {
            int docBase;
            if (hits == null) {
                if (sort == null) {
                    Logs.APP_LOG.debug((Object)("search in batches query " + query));
                    hits = indexSearcher.search(query, null, batchSize);
                } else {
                    Logs.APP_LOG.debug((Object)("search in batches sort " + sort + " query " + query));
                    hits = indexSearcher.search(query, null, batchSize, sort);
                }
                docBase = 0;
                readLimit = Math.min(readLimit, hits.totalHits);
            } else if (sort == null) {
                Logs.APP_LOG.debug((Object)("search (AFTER) in batches query " + query));
                ScoreDoc after = hits.scoreDocs[hits.scoreDocs.length - 1];
                hits = indexSearcher.searchAfter(after, query, null, batchSize);
                docBase = 0;
            } else {
                Logs.APP_LOG.debug((Object)("search (AFTER) in batches sort " + sort + " query " + query));
                hits = indexSearcher.search(query, null, read + batchSize, sort);
                docBase = read;
            }
            for (int i2 = docBase; i2 < hits.scoreDocs.length && read < readLimit; ++read, ++i2) {
                boolean continues = collector.collect(indexSearcher, hits.scoreDocs[i2]);
                if (continues) continue;
                return;
            }
        }
    }

    public static Field Indexed(String name, String value) {
        if (value == null) {
            value = "";
        }
        return new Field(name, value, Field.Store.NO, Field.Index.NOT_ANALYZED);
    }

    public static Field Keyword(String name, String value) {
        if (value == null) {
            value = "";
        }
        return new Field(name, value, Field.Store.YES, Field.Index.NOT_ANALYZED);
    }

    public static Field Text(String name, String value) {
        if (value == null) {
            value = "";
        }
        return new Field(name, value, Field.Store.YES, Field.Index.ANALYZED);
    }

    public static Field Text(String name, Reader value) {
        return new Field(name, value, Field.TermVector.NO);
    }

    public static BitSet collectDocumentsWithTerm(IndexReader reader, String term) throws IOException {
        final BitSet bits = new BitSet(reader.maxDoc());
        try {
            Term startTerm = new Term(term, "");
            Term endTerm = null;
            TermDocVistor.visitTermDocs(reader, startTerm, endTerm, new TermDocVistor.Visitor(){

                @Override
                public boolean visitTerm(Term t2) {
                    return true;
                }

                @Override
                public boolean visitDoc(int docId) {
                    bits.set(docId);
                    return true;
                }
            });
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"unexpected ex", (Throwable)e2);
        }
        return bits;
    }

    public static FastDateFormat getTimestampFormat() {
        return (FastDateFormat)fastDateFormat.get();
    }

    public static String formatTimestamp(Date date) {
        return date == null ? null : TIMESTAMP_FORMATTER.print(date.getTime());
    }

    public static Date parseDate(String fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(INDEXED_DATE_FORMAT);
            df.setTimeZone(DateHelper.GMT);
            return df.parse(fieldValue);
        }
        catch (ParseException e2) {
            Logs.APP_LOG.error((Object)("Failed to parse date '" + fieldValue + "'"), (Throwable)e2);
            return null;
        }
    }

    public static void addDateClause(BooleanQuery bq, Date minDate, Date maxDate) {
        if (minDate != null || maxDate != null) {
            String min = minDate == null ? null : LuceneHelper.getTimestampFormat().format(minDate);
            String max = maxDate == null ? null : LuceneHelper.getTimestampFormat().format(maxDate);
            TermRangeQuery dq = new TermRangeQuery(DATE_TIME_MS, min, max, true, true);
            bq.add((Query)dq, BooleanClause.Occur.MUST);
        }
    }

    public static BooleanQuery combineQueries(BooleanClause.Occur occur, Query ... subQueries) {
        BooleanQuery bq = new BooleanQuery();
        LuceneHelper.addQueries(bq, occur, subQueries);
        return bq;
    }

    public static void addQueries(BooleanQuery bq, BooleanClause.Occur occur, Query ... subQueries) {
        for (Query q2 : subQueries) {
            if (q2 == null) continue;
            bq.add(q2, occur);
        }
    }

    public static interface BatchCollector {
        public boolean collect(IndexSearcher var1, ScoreDoc var2) throws IOException;
    }
}

