/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.reader.DefaultIndexReaderFactory;
import com.cenqua.fisheye.lucene.reader.IndexReaderFactory;
import com.cenqua.fisheye.lucene.searcher.DefaultIndexSearcherFactory;
import com.cenqua.fisheye.lucene.searcher.IndexSearcherFactory;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.lucene.writer.IndexWriterFactory;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.PropertiesUtil;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class LuceneConnection<IC extends IndexConfig> {
    public static final Version VERSION = Version.LUCENE_36;
    private static final String INDEXDIR_PREFIX = "idx";
    private static final IndexReaderFactory INDEX_READER_FACTORY = new DefaultIndexReaderFactory();
    private static final IndexSearcherFactory INDEX_SEARCHER_FACTORY = new DefaultIndexSearcherFactory();
    private static final IndexWriterFactory INDEX_WRITER_FACTORY = new DefaultIndexWriterFactory();
    public static final long UNDEFINED_INDEX_SERIAL = -1L;
    private final File basedir;
    private final Analyzer analyzer;
    private final Properties properties;
    private final Object propertiesLock = new Object();
    private final Map<IC, IndexHandle> indexHandles = new LinkedHashMap<IC, IndexHandle>();

    public void recreateIndex(IC index) throws DbException {
        try {
            this.indexHandles.get(index).createIndex();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public LuceneConnection(File basedir, Analyzer analyzer, IC[] indexes) throws IOException {
        this.basedir = basedir;
        this.analyzer = analyzer;
        for (IC i2 : indexes) {
            this.indexHandles.put(i2, new IndexHandle(this, (IndexConfig)i2, basedir));
        }
        this.properties = PropertiesUtil.loadFromFile(this.getPropertiesFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withIndexSearcher(IC index, IndexSearcherAction<T> action) throws DbException {
        IndexHandle indexHandle = this.indexHandles.get(index);
        try {
            IndexReader indexReader = indexHandle.getReader();
            try {
                T t2 = action.perform(INDEX_SEARCHER_FACTORY.newIndexSearcher(indexReader));
                return t2;
            }
            finally {
                indexReader.decRef();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withIndexReader(IC index, IndexReaderAction<T> action) throws DbException {
        IndexHandle indexHandle = this.indexHandles.get(index);
        try {
            IndexReader indexReader = indexHandle.getReader();
            try {
                T t2 = action.perform(indexReader);
                return t2;
            }
            finally {
                indexReader.decRef();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public IndexReader leakIndexReader(IC index) {
        IndexHandle indexHandle = this.indexHandles.get(index);
        return indexHandle.getReader();
    }

    public void withIndexSearchers(Set<? extends IC> requiredIndexes, IndexSearcherActionN<IC> action) throws DbException {
        LinkedHashMap<IndexConfig, IndexSearcher> indexSearchers = new LinkedHashMap<IndexConfig, IndexSearcher>();
        ArrayList<IndexReader> indexReaders = new ArrayList<IndexReader>(requiredIndexes.size());
        try {
            for (IndexConfig idx : requiredIndexes) {
                IndexReader indexReader = this.indexHandles.get(idx).getReader();
                indexReaders.add(indexReader);
                indexSearchers.put(idx, INDEX_SEARCHER_FACTORY.newIndexSearcher(indexReader));
            }
            action.perform(indexSearchers);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            LuceneConnection.release(indexReaders);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T withWriter(IC idx, WriterAction<T> action) throws DbException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createIndexes() throws DbException {
        try {
            for (IndexHandle indexHandle : this.indexHandles.values()) {
                indexHandle.createIndex();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void saveIndexSerial(IndexHandle indexHandle) throws IOException {
        this.setProperty(String.format("serial.%s", indexHandle.index.getIndex()), String.valueOf(System.currentTimeMillis()));
    }

    public long getIndexSerial(IC index) throws IOException {
        String serial = this.getProperty(String.format("serial.%s", index.getIndex()));
        return serial == null ? -1L : Long.parseLong(serial);
    }

    public void killLuceneLocks() throws DbException {
        try {
            for (IndexHandle indexHandle : this.indexHandles.values()) {
                indexHandle.killLuceneLocks();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void close() {
        for (IndexHandle indexHandle : this.indexHandles.values()) {
            indexHandle.close();
        }
    }

    private static void release(Iterable<IndexReader> indexReaders) {
        for (IndexReader reader : indexReaders) {
            try {
                reader.decRef();
            }
            catch (IOException e2) {
                Logs.APP_LOG.warn((Object)"problem releasing index reader", (Throwable)e2);
            }
        }
    }

    public String getProperty(String propertyName) throws IOException {
        return this.properties.getProperty(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, String value) throws IOException {
        Object object = this.propertiesLock;
        synchronized (object) {
            if (value != null) {
                this.properties.setProperty(propertyName, value);
            } else {
                this.properties.remove(propertyName);
            }
            PropertiesUtil.writeToFile(this.properties, this.getPropertiesFile());
        }
    }

    public boolean checkIndexVersionIsCurrent(String currentVersion, IC index) throws IOException {
        return currentVersion.equals(this.getIndexVersion(index));
    }

    public String getIndexVersion(IC index) throws IOException {
        return this.getProperty(this.getIndexVersionPropertyName(index));
    }

    private String getIndexVersionPropertyName(IC index) {
        return "indexVersion." + index.getIndex();
    }

    public void updateIndexVersion(String currentVersion, IC index) throws IOException {
        this.setProperty(this.getIndexVersionPropertyName(index), currentVersion);
    }

    private File getPropertiesFile() {
        return new File(this.basedir, "index.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProperties() {
        Object object = this.propertiesLock;
        synchronized (object) {
            this.properties.clear();
            IOHelper.deleteFile(this.getPropertiesFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(Function<String, String> newPropertyValuesFunction) throws IOException {
        Object object = this.propertiesLock;
        synchronized (object) {
            Enumeration<?> propertyNames = this.properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = String.valueOf(propertyNames.nextElement());
                String newValue = (String)newPropertyValuesFunction.apply((Object)key);
                this.setProperty(key, newValue);
            }
        }
    }

    public static interface BatchedWriterAction<T> {
        public void perform(IndexWriter var1, T var2) throws IOException, DbException;
    }

    public static interface WriterAction<T> {
        public T perform(IndexWriter var1) throws IOException, DbException;
    }

    public static interface IndexSearcherActionN<IC extends IndexConfig> {
        public void perform(Map<IC, IndexSearcher> var1) throws IOException, DbException;
    }

    public static interface IndexReaderAction<T> {
        public T perform(IndexReader var1) throws IOException, DbException;
    }

    public static interface IndexSearcherAction<T> {
        public T perform(IndexSearcher var1) throws IOException, DbException;
    }

    public static interface IndexConfig {
        public String name();

        public int getIndex();
    }

    private static class IndexHandle {
        private final IC index;
        private final FSDirectory directory;
        private final Object readerLock = new Object();
        private volatile IndexReader reader;
        private final ReentrantLock writerLock = new ReentrantLock();
        private volatile IndexWriter writer;
        private volatile boolean stale;
        final /* synthetic */ LuceneConnection this$0;

        private IndexHandle(IC index, File basedir) throws IOException {
            this.this$0 = var1_1;
            this.index = index;
            this.directory = FSDirectory.open((File)new File(basedir, LuceneConnection.INDEXDIR_PREFIX + index.getIndex()));
        }

        private void checkIndexExists() throws DbException, IOException {
            if (!IndexReader.indexExists((Directory)this.directory)) {
                Logs.APP_LOG.debug((Object)("Lucene index " + this.index + " didn't exist, creating now"));
                this.createIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            IndexReader reader;
            IndexWriter writer;
            this.writerLock.lock();
            try {
                writer = this.writer;
                this.writer = null;
            }
            finally {
                this.writerLock.unlock();
            }
            Object object = this.readerLock;
            synchronized (object) {
                reader = this.reader;
                this.reader = null;
            }
            if (writer != null) {
                try {
                    if (Logs.APP_LOG.isDebugEnabled()) {
                        Logs.APP_LOG.debug((Object)("##closing writer " + this.index));
                    }
                    writer.close();
                }
                catch (IOException e2) {
                    Logs.APP_LOG.warn((Object)"problem closing index writer", (Throwable)e2);
                }
            }
            if (reader != null) {
                try {
                    if (Logs.APP_LOG.isDebugEnabled()) {
                        Logs.APP_LOG.debug((Object)("##closing reader " + this.index));
                    }
                    reader.close();
                }
                catch (IOException e3) {
                    Logs.APP_LOG.warn((Object)"problem closing index reader", (Throwable)e3);
                }
            }
        }

        private void commit() throws IOException {
            this.assertWriterLockHeld();
            if (this.writer != null) {
                try {
                    this.writer.commit();
                }
                catch (IOException e2) {
                    Logs.APP_LOG.error((Object)("problem committing index writer " + this.index), (Throwable)e2);
                    throw e2;
                }
                this.stale = true;
            }
        }

        private void createIndex() throws DbException, IOException {
            File file = this.directory.getDirectory();
            file.mkdirs();
            if (!file.isDirectory()) {
                throw new DbException("could not create directory: " + file.getAbsolutePath());
            }
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)(file.getPath() + " Before recreating index: " + Arrays.asList(file.list())));
            }
            IndexWriter writer = INDEX_WRITER_FACTORY.create((Directory)this.directory, this.this$0.analyzer, true);
            writer.commit();
            writer.close();
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)(file.getPath() + " After recreating index: " + Arrays.asList(file.list())));
            }
            this.this$0.saveIndexSerial(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IndexReader getReader() throws DbException {
            Object object = this.readerLock;
            synchronized (object) {
                try {
                    if (this.reader == null) {
                        if (Logs.APP_LOG.isDebugEnabled()) {
                            Logs.APP_LOG.debug((Object)("##opening reader " + this.index));
                        }
                        this.checkIndexExists();
                        this.reader = INDEX_READER_FACTORY.newIndexReader((Directory)this.directory);
                    } else if (this.stale) {
                        IndexReader newReader;
                        IndexReader oldReader;
                        if (Logs.APP_LOG.isDebugEnabled()) {
                            Logs.APP_LOG.debug((Object)("##re-opening reader " + this.index));
                        }
                        if ((oldReader = this.reader) != null && (newReader = IndexReader.openIfChanged((IndexReader)oldReader)) != null) {
                            oldReader.decRef();
                            this.reader = newReader;
                        }
                    }
                }
                catch (IOException exception) {
                    throw new DbException(exception);
                }
                this.stale = false;
                this.reader.incRef();
                return this.reader;
            }
        }

        private IndexWriter getWriter() throws DbException {
            this.assertWriterLockHeld();
            if (this.writer == null) {
                try {
                    this.checkIndexExists();
                    if (Logs.APP_LOG.isDebugEnabled()) {
                        Logs.APP_LOG.debug((Object)("##opening writer " + this.index + " at " + this.directory.getDirectory()));
                    }
                    this.writer = INDEX_WRITER_FACTORY.create((Directory)this.directory, this.this$0.analyzer, false);
                }
                catch (IOException exception) {
                    throw new DbException(exception);
                }
            }
            return this.writer;
        }

        private void killLuceneLocks() throws IOException {
            IndexWriter.unlock((Directory)this.directory);
            org.apache.lucene.store.Lock l2 = this.directory.makeLock("write.lock");
            if (l2.isLocked()) {
                Logs.APP_LOG.warn((Object)("write lock still locked " + l2));
            }
        }

        private void rollback() {
            this.assertWriterLockHeld();
            try {
                this.writer.rollback();
                this.writer = null;
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)("problem rolling back index writer " + this.index), (Throwable)e2);
            }
        }

        private Lock getWriterLock() {
            return this.writerLock;
        }

        private void assertWriterLockHeld() {
            if (!this.writerLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Lock not held");
            }
        }

        static /* synthetic */ Lock access$700(IndexHandle x0) {
            return x0.getWriterLock();
        }

        static /* synthetic */ IndexWriter access$800(IndexHandle x0) throws DbException {
            return x0.getWriter();
        }

        static /* synthetic */ void access$900(IndexHandle x0) throws IOException {
            x0.commit();
        }

        static /* synthetic */ void access$1000(IndexHandle x0) {
            x0.rollback();
        }
    }
}

