/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class FreeTextAnalyzer
extends Analyzer {
    private static final int MAX_TOKEN_LEN = 100;
    private static final IntSet OPERATOR_CHARS = new IntOpenHashSet();

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new SmartyPantsTokenStream(reader);
    }

    static {
        OPERATOR_CHARS.add(43);
        OPERATOR_CHARS.add(45);
        OPERATOR_CHARS.add(42);
        OPERATOR_CHARS.add(47);
        OPERATOR_CHARS.add(37);
        OPERATOR_CHARS.add(92);
        OPERATOR_CHARS.add(61);
        OPERATOR_CHARS.add(60);
        OPERATOR_CHARS.add(62);
        OPERATOR_CHARS.add(33);
        OPERATOR_CHARS.add(126);
        OPERATOR_CHARS.add(46);
        OPERATOR_CHARS.add(38);
        OPERATOR_CHARS.add(124);
        OPERATOR_CHARS.add(94);
        OPERATOR_CHARS.add(91);
        OPERATOR_CHARS.add(93);
        OPERATOR_CHARS.add(95);
        OPERATOR_CHARS.add(64);
    }

    private static final class SmartyPantsTokenStream
    extends Tokenizer {
        private int mCurrentPos;
        private final PushbackReader pb;
        private final CharTermAttribute token;
        private final OffsetAttribute offset;
        public static final int WORD = 1;
        public static final int OPER = 2;
        public static final int SKIP = 3;

        public SmartyPantsTokenStream(Reader input) {
            super(input);
            this.pb = new PushbackReader(input, 1);
            this.token = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            this.offset = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        }

        public static int typeOf(char c2) {
            if (SmartyPantsTokenStream.isWord(c2)) {
                return 1;
            }
            if (SmartyPantsTokenStream.isOper(c2)) {
                return 2;
            }
            return 3;
        }

        public boolean incrementToken() throws IOException {
            int c2;
            int t2 = 3;
            while (-1 != (c2 = this.pb.read())) {
                ++this.mCurrentPos;
                t2 = SmartyPantsTokenStream.typeOf((char)c2);
                if (t2 == 3) continue;
            }
            if (c2 == -1) {
                return false;
            }
            int start = this.mCurrentPos - 1;
            StringBuilder buf = new StringBuilder();
            buf.append(t2 == 1 ? this.normalize((char)c2) : (char)c2);
            while (-1 != (c2 = this.pb.read())) {
                int t22 = SmartyPantsTokenStream.typeOf((char)c2);
                if (t22 != t2) {
                    this.pb.unread(c2);
                    break;
                }
                ++this.mCurrentPos;
                if (buf.length() >= 100) continue;
                buf.append(t2 == 1 ? this.normalize((char)c2) : (char)c2);
            }
            this.token.setEmpty().append(buf.toString());
            this.offset.setOffset(start, start + buf.length());
            return true;
        }

        private char normalize(char c2) {
            return Character.toLowerCase(c2);
        }

        private static boolean isOper(char c2) {
            return OPERATOR_CHARS.contains((int)c2);
        }

        private static boolean isWord(char c2) {
            return Character.isLetterOrDigit(c2);
        }
    }
}

