/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;

public class CrossRepLuceneIndex {
    public static final String VERSION = "9";
    private static final Integer LAST_UPGRADABLE_VERSION = 4;
    public static final CrossRepLuceneIndexes CS_INDEX = CrossRepLuceneIndexes.METADATA;
    public static final int CHANGESET_BATCH_SIZE = 1000;
    public static final long CHANGESET_INDEX_SENTINEL = -1L;
    private static final String REP_RESCANNED_STATUS_PREFIX = "repRescannedStatus.";
    private static final String REP_RESCANNED_PREFIX = "repRescanned.";
    public static final String GLOBAL_INDEX_DIR = "globalfe";
    private LuceneConnection<CrossRepLuceneIndexes> connection;
    private final File baseDir;

    public CrossRepLuceneIndex(File cacheDir) throws DbException {
        this(cacheDir, true);
    }

    public CrossRepLuceneIndex(File cacheDir, boolean open) throws DbException {
        this.baseDir = new File(cacheDir, GLOBAL_INDEX_DIR);
        if (open) {
            this.open();
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public synchronized void open() {
        if (this.connection == null) {
            try {
                this.openNoUpgrade();
                String indexVersion = this.connection.getIndexVersion(CS_INDEX);
                if (!this.connection.checkIndexVersionIsCurrent(VERSION, CS_INDEX)) {
                    if (indexVersion != null) {
                        Logs.APP_LOG.info((Object)("Upgrading lucene crossrepo index from " + indexVersion + " to " + VERSION));
                    }
                    if (indexVersion != null && Integer.parseInt(indexVersion) >= LAST_UPGRADABLE_VERSION) {
                        this.connection.updateProperties(new Function<String, String>(){

                            public String apply(String input) {
                                if (input.startsWith(CrossRepLuceneIndex.REP_RESCANNED_STATUS_PREFIX)) {
                                    return null;
                                }
                                try {
                                    return CrossRepLuceneIndex.this.connection.getProperty(input);
                                }
                                catch (IOException e2) {
                                    throw new DbException(e2);
                                }
                            }
                        });
                    } else {
                        if (indexVersion != null) {
                            Logs.APP_LOG.info((Object)("Index version is " + indexVersion + ", and not upgradable, resetting index."));
                        }
                        this.connection.resetProperties();
                    }
                    this.connection.updateIndexVersion(VERSION, CS_INDEX);
                } else {
                    Logs.APP_LOG.debug((Object)("Lucene crossrepo index is already at " + indexVersion));
                }
            }
            catch (IOException e2) {
                throw new DbException("Error creating cross repository lucene index", e2);
            }
        }
    }

    public synchronized void openNoUpgrade() {
        if (this.connection == null) {
            try {
                this.connection = new LuceneConnection(this.baseDir, (Analyzer)new FreeTextAnalyzer(), (LuceneConnection.IndexConfig[])CrossRepLuceneIndexes.values());
                this.connection.killLuceneLocks();
            }
            catch (IOException e2) {
                throw new DbException("Error creating cross repository lucene index", e2);
            }
        }
    }

    public synchronized void close() throws DbException {
        if (this.connection != null) {
            this.connection.close();
            this.connection.killLuceneLocks();
            this.connection = null;
        }
    }

    public synchronized LuceneConnection<CrossRepLuceneIndexes> getConnection() {
        LuceneConnection<CrossRepLuceneIndexes> conn = this.connection;
        if (conn == null) {
            throw new IllegalStateException("The cross-repository index is closed");
        }
        return conn;
    }

    public RescanStatus getRescanStatus(RevisionCache cache) throws DbException {
        try {
            boolean serialChanged;
            String existingFlag = this.getConnection().getProperty(this.getRepRescannedFlagPropertyName(cache.getRepositoryName()));
            String hasPre24ChangesetsProp = this.getConnection().getProperty(this.getRepRescannedHasPre24Changesets(cache.getRepositoryName()));
            Boolean hasPre24Changesets = hasPre24ChangesetsProp == null ? null : Boolean.valueOf(hasPre24ChangesetsProp);
            boolean bl = serialChanged = !Long.toString(cache.getCacheSerialNumber()).equals(existingFlag);
            if (serialChanged) {
                return new RescanStatus(true, hasPre24Changesets, null);
            }
            return new RescanStatus(false, hasPre24Changesets, this.getLastScannedChangeset(cache));
        }
        catch (IOException e2) {
            throw new DbException("Error getting cross repository rep rescan status", e2);
        }
    }

    public void setRescanStatus(RevisionCache cache, Long changesetId, Boolean hasPre24Changesets) throws DbException {
        try {
            this.getConnection().setProperty(this.getRepRescannedFlagPropertyName(cache.getRepositoryName()), Long.toString(cache.getCacheSerialNumber()));
            this.setLastScannedChangeset(cache, changesetId);
            this.getConnection().setProperty(this.getRepRescannedHasPre24Changesets(cache.getRepositoryName()), hasPre24Changesets == null ? null : hasPre24Changesets.toString());
        }
        catch (IOException e2) {
            throw new DbException("Error setting cross repository rep rescan status", e2);
        }
    }

    @Nullable
    private Long getLastScannedChangeset(RevisionCache cache) throws IOException {
        String lastChangesetProperty = this.getRepRescannedLastChangesetPropertyName(cache.getRepositoryName());
        String property = this.getConnection().getProperty(lastChangesetProperty);
        return property == null ? null : Long.valueOf(property);
    }

    private void setLastScannedChangeset(RevisionCache cache, Long changesetId) throws IOException {
        String lastChangesetProperty = this.getRepRescannedLastChangesetPropertyName(cache.getRepositoryName());
        if (changesetId == null) {
            this.getConnection().setProperty(lastChangesetProperty, null);
        } else {
            this.getConnection().setProperty(lastChangesetProperty, changesetId.toString());
        }
    }

    private String getRepRescannedFlagPropertyName(String repositoryName) {
        return REP_RESCANNED_PREFIX + CS_INDEX.getIndex() + "." + repositoryName;
    }

    private String getRepRescannedLastChangesetPropertyName(String repositoryName) {
        return "repRescannedStatus.cs." + CS_INDEX.getIndex() + "." + repositoryName;
    }

    private String getRepRescannedHasPre24Changesets(String repositoryName) {
        return "repRescannedStatus.pre24changesets." + CS_INDEX.getIndex() + "." + repositoryName;
    }

    public void deleteRepFromIndex(String repositoryName) throws DbException {
        final Term term = new Term("rep", repositoryName);
        this.getConnection().withWriter(CS_INDEX, new LuceneConnection.WriterAction<Void>(){

            @Override
            public Void perform(IndexWriter writer) throws IOException {
                writer.deleteDocuments(term);
                return null;
            }
        });
        try {
            this.getConnection().setProperty(this.getRepRescannedFlagPropertyName(repositoryName), "0");
        }
        catch (IOException e2) {
            throw new DbException("Error clearing cross repository rep rescan status", e2);
        }
    }

    public void purgeOldReps(Set<String> currentReps) throws DbException {
        Set<String> indexReps = this.getConnection().withIndexSearcher(CS_INDEX, new LuceneConnection.IndexSearcherAction<Set<String>>(){

            @Override
            public Set<String> perform(IndexSearcher indexSearcher) throws IOException, DbException {
                return LuceneHelper.findTerms(indexSearcher.getIndexReader(), "rep");
            }
        });
        indexReps.removeAll(currentReps);
        for (String indexRep : indexReps) {
            this.deleteRepFromIndex(indexRep);
        }
    }

    public static class RescanStatus {
        private final boolean serialChanged;
        private final Boolean hasPre24Changesets;
        @Nullable
        private final Long lastScannedChangeset;

        public RescanStatus(boolean serialChanged, Boolean hasPre24Changesets, @Nullable Long lastScannedChangeset) {
            this.serialChanged = serialChanged;
            this.lastScannedChangeset = lastScannedChangeset;
            this.hasPre24Changesets = hasPre24Changesets;
        }

        public boolean isSerialChanged() {
            return this.serialChanged;
        }

        @Nullable
        public Long getLastScannedChangeset() {
            return this.lastScannedChangeset;
        }

        @Nullable
        public Boolean hasPre24Changesets() {
            return this.hasPre24Changesets;
        }

        public boolean needsPre24ChangesetHandling() {
            return this.hasPre24Changesets == null ? true : this.hasPre24Changesets;
        }

        public boolean isDone() {
            return !this.serialChanged && Long.valueOf(-1L).equals(this.lastScannedChangeset);
        }
    }
}

