/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public abstract class AbstractBitsetQuery
extends Query {
    protected float score = 0.0f;

    protected abstract BitSet computeBitset(IndexReader var1) throws IOException;

    protected abstract String getFilterExplanation();

    public Query rewrite(IndexReader reader) throws IOException {
        class SkipReaderBitsQuery
        extends Query {
            SkipReaderBitsQuery() {
            }

            public String toString(String field) {
                String res = "SkipReaderBitsQuery( " + AbstractBitsetQuery.this.getFilterExplanation() + ")";
                if (field == null) {
                    return res;
                }
                return res + "(" + field + " ?)";
            }

            public Weight createWeight(Searcher searcher) {
                class FilterWeight
                extends Weight {
                    FilterWeight() {
                    }

                    public float getValue() {
                        return 0.0f;
                    }

                    public void normalize(float norm) {
                    }

                    public float sumOfSquaredWeights() {
                        return 0.0f;
                    }

                    public Query getQuery() {
                        return AbstractBitsetQuery.this;
                    }

                    public Explanation explain(IndexReader reader, int doc) {
                        return new Explanation(this.getValue(), "weightless " + AbstractBitsetQuery.this.getFilterExplanation());
                    }

                    public Scorer scorer(final IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
                        class SkipReaderBitsScorer
                        extends Scorer {
                            BitSet docNrs;
                            int currentDoc;

                            SkipReaderBitsScorer() throws IOException {
                                super((Weight)null);
                                this.docNrs = AbstractBitsetQuery.this.computeBitset(reader);
                                this.currentDoc = -1;
                            }

                            public int docID() {
                                return this.currentDoc;
                            }

                            public float score() {
                                return AbstractBitsetQuery.this.score;
                            }

                            public int nextDoc() {
                                int doc = this.docNrs.nextSetBit(this.currentDoc + 1);
                                this.currentDoc = doc == -1 ? Integer.MAX_VALUE : doc;
                                return this.currentDoc;
                            }

                            public int advance(int target) {
                                int doc = this.docNrs.nextSetBit(this.currentDoc < target ? target : this.currentDoc + 1);
                                this.currentDoc = doc == -1 ? Integer.MAX_VALUE : doc;
                                return this.currentDoc;
                            }
                        }
                        return new SkipReaderBitsScorer();
                    }
                }
                return new FilterWeight();
            }
        }
        return new SkipReaderBitsQuery();
    }
}

