/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.logging;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class ThrottledTriggeringEventEvaluator
implements TriggeringEventEvaluator {
    private static final AtomicInteger countSinceReset = new AtomicInteger(0);
    private static final AtomicLong timestamp = new AtomicLong(System.currentTimeMillis());
    private static final long THRESHOLD = 10000L;
    private static final int MAX_MESSAGES = 10;

    public boolean isTriggeringEvent(LoggingEvent event) {
        long now = System.currentTimeMillis();
        if (timestamp.longValue() + 10000L > now) {
            countSinceReset.set(countSinceReset.intValue() / 2);
            timestamp.set(now);
            return true;
        }
        return countSinceReset.incrementAndGet() <= 10;
    }
}

