/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.logging;

import com.atlassian.fecru.utils.DebugAware;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.web.admin.actions.HtmlTesterLayout;
import com.google.common.collect.ImmutableList;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Logs {
    public static final String HTTPCLIENT_WIRE = "org.apache.http.wire";
    public static final Logger APP_LOG = Logger.getLogger((String)"fisheye");
    public static final Logger MAIL_LOG = Logger.getLogger((String)"fisheye.mail");
    private static final List<String> otherDebugLoggers = new ImmutableList.Builder().add((Object)"com.atlassian.stash.rest.client.applinks").add((Object)"com.atlassian.fecru.plugin.jira").add((Object)"com.atlassian.fecru.plugins.jirarest").add((Object)"com.atlassian.crucible.plugins.branchreview").add((Object)"com.atlassian.analytics").add((Object)"com.atlassian.fecru.plugin.analytics").add((Object)"com.atlassian.sal.fisheye").add((Object)"com.atlassian.fisheye.repositron").add((Object)"com.atlassian.support.tools").add((Object)"com.atlassian.crowd").add((Object)"com.atlassian.event.remote").build();
    private static int ANON_COUNTER = 1;

    public static Priority setConsoleLevel(Priority threshold) {
        return Logs.setAppenderThreshold("console", threshold);
    }

    public static Priority setAppenderThreshold(String appenderName, Priority threshold) {
        Appender appender = APP_LOG.getAppender(appenderName);
        if (appender != null && appender instanceof AppenderSkeleton) {
            AppenderSkeleton skeleton = (AppenderSkeleton)appender;
            Priority old = skeleton.getThreshold();
            skeleton.setThreshold(threshold);
            return old;
        }
        return null;
    }

    public static void init() {
        Handler[] handlers = LogManager.getLogManager().getLogger("").getHandlers();
        boolean installSLF4JBridgeHandler = true;
        if (handlers != null) {
            for (Handler handler : handlers) {
                if (!(handler instanceof SLF4JBridgeHandler)) continue;
                installSLF4JBridgeHandler = false;
                break;
            }
        }
        if (installSLF4JBridgeHandler) {
            SLF4JBridgeHandler.install();
        }
        Logs.setConsoleLevel((Priority)Level.INFO);
    }

    public static Logger makeAnonymousLogger() {
        Logger logger = Logger.getLogger((String)("fisheye.debug." + ANON_COUNTER++));
        logger.setLevel(Level.ALL);
        return logger;
    }

    public static Appender makeTestAppender(Writer writer, String ndc, Map style) {
        HtmlTesterLayout layout = new HtmlTesterLayout(style != null ? style : HtmlTesterLayout.getDefaultStyle(), ndc);
        WriterAppender appender = new WriterAppender((Layout)layout, writer);
        appender.setThreshold((Priority)Level.ALL);
        appender.setImmediateFlush(true);
        return appender;
    }

    public static boolean isDebugMode() {
        return APP_LOG.getLevel() == Level.DEBUG;
    }

    public static void setupQuietMode() {
        Logs.setConsoleLevel((Priority)Level.OFF);
    }

    public static void setupDebugMode() {
        Logs.setDebugMode(Level.DEBUG);
    }

    public static void disableDebugMode() {
        Logs.setDebugMode(Level.INFO);
    }

    private static void setDebugMode(Level level) {
        APP_LOG.setLevel(level);
        for (String logger : otherDebugLoggers) {
            Logger.getLogger((String)logger).setLevel(level);
        }
        boolean state = level.equals((Object)Level.DEBUG);
        if (SpringContext.isSetup()) {
            for (DebugAware c2 : SpringContext.getComponentsByClass(DebugAware.class)) {
                c2.setDebug(state);
            }
        }
    }

    public static void disableWireDebugMode() {
        Logger.getLogger((String)HTTPCLIENT_WIRE).setLevel(Level.OFF);
    }

    public static void enableWireDebugMode() {
        Logger.getLogger((String)HTTPCLIENT_WIRE).setLevel(Level.DEBUG);
    }

    public static void enableMailDebugLogging() {
        MAIL_LOG.setLevel(Level.DEBUG);
    }

    public static void disableMailDebugLogging() {
        MAIL_LOG.setLevel(Level.INFO);
    }

    public static void logWarningWithDetailToDebug(String baseMessage, Throwable e2) {
        String warningMessage = baseMessage + ": " + e2.toString() + (APP_LOG.isDebugEnabled() ? "(see debug logs for more details)" : " (enable debug logging for more details)");
        APP_LOG.warn((Object)warningMessage);
        APP_LOG.debug((Object)baseMessage, e2);
    }

    public static Logger loggerFor(Class<?> clazz) {
        return APP_LOG;
    }

    public static class Warnings {
        public static boolean warnOnDupicatesInAttic = true;
        public static boolean warnOnDupicatesInAtticJustOnce = true;
        public static boolean warnMailerNotConfiguredJustOnce = true;
    }
}

