/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.logging;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.FileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyRollingFileAppender
extends FileAppender {
    private long nextCheck = System.currentTimeMillis() - 1L;
    private final Cal cal = new Cal();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String basename;
    private String baseFileName;
    private String extension;
    private Pattern regex;
    private int keepDays = 7;

    public int getKeepDays() {
        return this.keepDays;
    }

    public void setKeepDays(int keepDays) {
        this.keepDays = keepDays;
    }

    public String getBaseFile() {
        return this.baseFileName;
    }

    public void setBaseFile(String baseName) {
        this.basename = baseName;
        if (baseName.contains(".")) {
            int index = baseName.lastIndexOf(".");
            this.extension = baseName.substring(index + 1);
            this.baseFileName = baseName.substring(0, index);
        } else {
            this.extension = "log";
            this.baseFileName = baseName;
        }
        this.regex = Pattern.compile("^" + new File(this.baseFileName).getName() + "-([0-9]{4}-[0-9]{2}-[0-9]{2})." + this.extension + "$");
    }

    public void activateOptions() {
        if (this.baseFileName == null) {
            LogLog.error((String)("BaseFileName is not set for appender [" + this.name + "]."));
            return;
        }
        this.cal.setNow(System.currentTimeMillis());
        this.setFile(this.thisFileName());
        super.activateOptions();
    }

    void rollOver() {
        String nextFileName = this.thisFileName();
        if (nextFileName.equals(this.fileName)) {
            return;
        }
        LogLog.debug((String)("Rolling [" + this.name + "]"));
        try {
            this.setFile(nextFileName, this.fileAppend, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e2) {
            LogLog.error((String)("setFile(" + nextFileName + ", ...) call failed."), (Throwable)e2);
        }
        if (this.keepDays > 0) {
            this.deleteOldFiles();
        }
    }

    private void deleteOldFiles() {
        File dir = new File(this.fileName).getAbsoluteFile().getParentFile();
        if (dir == null || !dir.isDirectory()) {
            LogLog.error((String)("Could not find directory of logfile " + this.fileName));
            return;
        }
        long cutoff = this.cal.startOfDay(-this.keepDays - 1);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                this.deleteNewStyleLogFile(file, cutoff);
                this.deleteOldStyleLogFile(file, cutoff);
            }
        }
    }

    private void deleteOldStyleLogFile(File file, long cutoff) {
        String base = new File(this.basename).getName() + ".";
        String fn = file.getName();
        if (fn.startsWith(base)) {
            String tail = fn.substring(base.length());
            try {
                Date d2 = this.sdf.parse(tail);
                if (d2.getTime() <= cutoff) {
                    LogLog.debug((String)("Deleting " + file));
                    file.delete();
                }
            }
            catch (ParseException e2) {
                LogLog.error((String)("Ignoring logfile with strange suffix " + file));
            }
        }
    }

    private void deleteNewStyleLogFile(File file, long cutoff) {
        String fn = file.getName();
        Matcher matcher = this.regex.matcher(fn);
        if (matcher.matches()) {
            String dateString = matcher.group(1);
            try {
                Date d2 = this.sdf.parse(dateString);
                if (d2.getTime() <= cutoff) {
                    LogLog.debug((String)("Deleting " + file));
                    file.delete();
                }
            }
            catch (ParseException e2) {
                LogLog.error((String)("Ignoring logfile with strange date value " + file));
            }
        }
    }

    private String thisFileName() {
        return this.baseFileName + "-" + this.sdf.format(this.cal.startOfToday()) + "." + this.extension;
    }

    protected void subAppend(LoggingEvent event) {
        long n2 = System.currentTimeMillis();
        if (n2 >= this.nextCheck) {
            this.cal.setNow(n2);
            this.nextCheck = this.cal.startOfDay(1);
            this.rollOver();
        }
        super.subAppend(event);
    }

    private static class Cal {
        private final GregorianCalendar cal = new GregorianCalendar();
        private long now = System.currentTimeMillis();

        private Cal() {
        }

        public void setNow(long t2) {
            this.now = t2;
        }

        public Date startOfToday() {
            this.reset();
            return this.cal.getTime();
        }

        public long startOfDay(int offset) {
            this.reset();
            this.cal.add(5, offset);
            return this.cal.getTimeInMillis();
        }

        private void reset() {
            this.cal.setTimeInMillis(this.now);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
        }
    }
}

