/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.logging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class CategoryNDCFilter
extends Filter {
    private String ndcPrefix;
    private Set<String> categories;

    public String getNdcPrefix() {
        return this.ndcPrefix;
    }

    public void setNdcPrefix(String ndcPrefix) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ndcPrefix) ? 1 : 0) != 0, (Object)"NDC prefix must be provided");
        this.ndcPrefix = ndcPrefix;
    }

    Set<String> getCategoriesSet() {
        return this.categories;
    }

    void setCategoriesSet(Set<String> categories) {
        Preconditions.checkArgument((categories != null && !categories.isEmpty() ? 1 : 0) != 0, (Object)"Categories must be provided");
        this.categories = ImmutableSet.copyOf(categories);
    }

    public void setCategories(String commaSeparatedCategories) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commaSeparatedCategories) ? 1 : 0) != 0, (Object)"Categories must be provided");
        this.setCategoriesSet((Set<String>)ImmutableSet.copyOf((Object[])commaSeparatedCategories.trim().split("\\s*,\\s*")));
    }

    public void activateOptions() {
        super.activateOptions();
        this.setCategoriesSet(this.getCategoriesSet());
        this.setNdcPrefix(this.getNdcPrefix());
    }

    public int decide(LoggingEvent event) {
        String ndc;
        if (this.getCategoriesSet().contains(event.getLoggerName()) && null != (ndc = event.getNDC()) && ndc.startsWith(this.getNdcPrefix())) {
            return -1;
        }
        return 0;
    }
}

