/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.DateHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LicenseUtils {
    public static final long WEEK_MILLIS = 604800000L;

    public static boolean isValidForCurrentBuild(ProductLicense license) {
        long buildDate;
        boolean isValid = true;
        Long latestBuildAllowed = LicenseUtils.getLatestBuildAllowed(license);
        if (latestBuildAllowed != null && (buildDate = LicenseUtils.getOurBuildDate()) > latestBuildAllowed + 604800000L) {
            isValid = false;
        }
        return isValid;
    }

    public static long getOurBuildDate() throws LicenseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        try {
            return df.parse("2016-05-06").getTime();
        }
        catch (ParseException e2) {
            throw new LicenseException("Error parsing internal license date");
        }
    }

    public static Long getLatestBuildAllowed(ProductLicense license) throws LicenseException {
        if (license.getMaintenanceExpiryDate().getTime() > 0L) {
            return license.getMaintenanceExpiryDate().getTime();
        }
        return null;
    }

    public static String getInvalidBuildMessage(ProductLicense license) {
        return "Upgrades for your " + license.getProduct().getName() + " license ended " + DateHelper.toGmtString(new Date(LicenseUtils.getLatestBuildAllowed(license))) + ", and this version was built " + "2016-05-06";
    }

    public static boolean isShowOwnerInFooter(ProductLicense license) {
        return license.getExpiryDate() != null || license.getLicenseType() == LicenseType.COMMUNITY || license.getLicenseType() == LicenseType.OPEN_SOURCE || license.isEvaluation();
    }

    public static boolean isShouldHassle(ProductLicense license) {
        if (license.getExpiryDate() == null) {
            return false;
        }
        if (license.isExpired()) {
            return true;
        }
        long grace = 1209600000L;
        long now = System.currentTimeMillis();
        return license.getPurchaseDate().getTime() + grace < now;
    }

    public static int getIntProperty(ProductLicense license, String propName, int defaultValue) {
        String valueString = license.getProperty(propName);
        int value = defaultValue;
        if (valueString != null) {
            try {
                value = Integer.parseInt(valueString);
            }
            catch (NumberFormatException e2) {
                Logs.APP_LOG.warn((Object)"License Error - malformed property");
            }
        }
        return value;
    }
}

