/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.extras.common.LicenseException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.license.LicenseUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LicenseLoader {
    private final ConfigDocument.Config config;

    public LicenseLoader(ConfigDocument.Config config) {
        this.config = config;
    }

    public LicenseInfo loadAndValidate() throws LicenseException {
        LicenseHolder licenseHolder = this.readLicensesFromXml();
        this.validate(licenseHolder);
        return new LicenseInfo(licenseHolder);
    }

    public LicenseInfo updateLicensesFromXml(LicenseInfo info) throws LicenseException {
        LicenseHolder licenses = this.readLicensesFromXml();
        this.validate(licenses);
        if (licenses.hasCrucible() && licenses.hasFishEye()) {
            return new LicenseInfo(licenses);
        }
        if (licenses.hasFishEye()) {
            return new LicenseInfo(licenses);
        }
        if (licenses.hasCrucible()) {
            return new LicenseInfo(licenses);
        }
        return info;
    }

    protected void validate(LicenseHolder licenseHolder) throws LicenseException {
        if (!licenseHolder.hasFishEye() && !licenseHolder.hasCrucible()) {
            throw new LicenseException("Could not find a FishEye or Crucible license.");
        }
        if (licenseHolder.hasFishEye()) {
            if (!licenseHolder.canDecodeFishEye()) {
                throw new LicenseException("Your FishEye license is invalid.");
            }
            if (licenseHolder.isFishEyeGracePeriodExpired()) {
                throw new LicenseException("Your FishEye license terminated on " + this.formatDate(licenseHolder.getFishEyeLicense().getExpiryDate()));
            }
            if (!licenseHolder.isFishEyeValidForCurrentBuild()) {
                throw new LicenseException(LicenseUtils.getInvalidBuildMessage(licenseHolder.getFishEyeLicense()));
            }
        }
        if (licenseHolder.hasCrucible()) {
            if (!licenseHolder.canDecodeCrucible()) {
                throw new LicenseException("Your Crucible license is invalid.");
            }
            if (licenseHolder.isCrucibleGracePeriodExpired()) {
                throw new LicenseException("Your Crucible license terminated on " + this.formatDate(licenseHolder.getCrucibleLicense().getExpiryDate()));
            }
            if (!licenseHolder.isCrucibleValidForCurrentBuild()) {
                throw new LicenseException(LicenseUtils.getInvalidBuildMessage(licenseHolder.getCrucibleLicense()));
            }
        }
    }

    private String formatDate(Date expiredTime) {
        return new SimpleDateFormat("MMMM dd, yyyy").format(expiredTime);
    }

    protected LicenseHolder readLicensesFromXml() throws LicenseException {
        LicenseType licenseConfig = this.config.getLicense();
        String feLicense = licenseConfig.isSetFisheye() ? licenseConfig.getFisheye().trim() : null;
        String cruLicense = licenseConfig.isSetCrucible() ? licenseConfig.getCrucible().trim() : null;
        return LicenseHolder.makeFishEyeCrucibleLicense(feLicense, cruLicense);
    }
}

