/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.extras.api.ProductLicense;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseUtils;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class LicenseInfo {
    public static final int UNRESTRICTED_COMMITTERS = -1;
    public static final int UNRESTRICTED_REPOS = -1;
    private final ProductLicense feLicense;
    private final ProductLicense cruLicense;
    private final LicenseHolder lh;
    private static final int MAX_DAYS_BEFORE_RENEWAL_MESSAGE = 30;
    private static final long MILLIS_IN_A_DAY = 86400000L;

    public LicenseInfo(LicenseHolder lh) {
        this.lh = lh;
        this.feLicense = lh.getFishEyeLicense();
        this.cruLicense = lh.getCrucibleLicense();
    }

    public String getProductName() {
        StringBuilder builder = new StringBuilder();
        if (this.isFishEye()) {
            builder.append(this.feLicense.getProduct().getName());
        }
        if (this.isFishEye() && this.isCrucible()) {
            builder.append(", ");
        }
        if (this.isCrucible()) {
            builder.append(this.cruLicense.getProduct().getName());
        }
        return builder.toString();
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        if (this.isFishEye() && !StringUtils.isBlank((String)this.feLicense.getDescription())) {
            builder.append(this.feLicense.getDescription());
            if (this.isCrucible() && !StringUtils.isBlank((String)this.cruLicense.getDescription())) {
                builder.append(", ");
            }
        }
        if (this.isCrucible() && !StringUtils.isBlank((String)this.cruLicense.getDescription())) {
            builder.append(this.cruLicense.getDescription());
        }
        return builder.toString();
    }

    public boolean isJspSourceEdition() {
        File index_jsp = new File(AppConfig.getAppHome(), "content/index.jsp");
        return index_jsp.isFile() && index_jsp.length() > 1L;
    }

    public ProductLicense getFisheyeLicense() {
        return this.feLicense;
    }

    public String getFisheyeLicenseString() {
        return this.lh.getFishEyeLicenseString();
    }

    public ProductLicense getCrucibleLicense() {
        return this.cruLicense;
    }

    public String getCrucibleLicenseString() {
        return this.lh.getCrucibleLicenseString();
    }

    public boolean isGracePeriodExpired() {
        return this.feLicense.isGracePeriodExpired() || this.cruLicense != null && this.cruLicense.isGracePeriodExpired();
    }

    public boolean isTerminated() {
        return this.isGracePeriodExpired();
    }

    public boolean isExpired() {
        return this.feLicense.isExpired() || this.cruLicense != null && this.cruLicense.isExpired();
    }

    public boolean isMaintenanceExpired() {
        return this.feLicense.isMaintenanceExpired() || this.cruLicense != null && this.cruLicense.isMaintenanceExpired();
    }

    public boolean expires() {
        return this.feLicense.getExpiryDate() != null || this.cruLicense != null && this.cruLicense.getExpiryDate() != null;
    }

    public boolean getExpires() {
        return this.expires();
    }

    public long getSoftExpiry() {
        long val = Long.MAX_VALUE;
        if (this.feLicense.getExpiryDate() != null) {
            val = this.feLicense.getExpiryDate().getTime();
        }
        if (this.cruLicense != null && this.cruLicense.getExpiryDate() != null) {
            val = Math.min(val, this.cruLicense.getExpiryDate().getTime());
        }
        return val == Long.MAX_VALUE ? 0L : val;
    }

    public boolean getShowExpiryMessage() {
        return this.getMillisUntilMaintExpiry() <= 2592000000L;
    }

    public String getExpiryMessage() {
        String message;
        if (this.isMaintenanceExpired()) {
            message = "Your maintenance has expired.";
        } else {
            int days = (int)Math.ceil((double)this.getMillisUntilMaintExpiry() / 8.64E7);
            message = "You have " + days + " " + ExpressionUtil.pluralise("day", "days", days) + " before your maintenance expires.";
        }
        return message;
    }

    public long getMillisUntilMaintExpiry() {
        long expiry = Long.MAX_VALUE;
        if (this.feLicense.getMaintenanceExpiryDate() != null) {
            expiry = this.feLicense.getMaintenanceExpiryDate().getTime();
        }
        if (this.cruLicense != null && this.cruLicense.getMaintenanceExpiryDate() != null) {
            expiry = Math.min(expiry, this.cruLicense.getMaintenanceExpiryDate().getTime());
        }
        return expiry - System.currentTimeMillis();
    }

    public long getHardExpiry() {
        long val = Long.MAX_VALUE;
        if (this.feLicense.getGracePeriodEndDate() != null) {
            val = this.feLicense.getGracePeriodEndDate().getTime();
        }
        if (this.cruLicense != null && this.cruLicense.getGracePeriodEndDate() != null) {
            val = Math.min(val, this.cruLicense.getGracePeriodEndDate().getTime());
        }
        return val == Long.MAX_VALUE ? 0L : val;
    }

    public Date getSoftExpiryValue() {
        return new Date(this.getSoftExpiry());
    }

    public Date getHardExpiryValue() {
        return new Date(this.getHardExpiry());
    }

    public String getOwnerStatement() {
        ProductLicense license = this.cruLicense != null ? this.cruLicense : this.feLicense;
        StringBuilder sb = new StringBuilder();
        String description = license.getDescription();
        if (!StringUtils.isBlank((String)description)) {
            sb.append(description).append(" ");
        }
        sb.append("License registered to ").append(license.getOrganisation().getName()).append(".");
        return sb.toString();
    }

    public String getOwner() {
        if (this.cruLicense != null) {
            return this.cruLicense.getOrganisation().getName();
        }
        return this.feLicense.getOrganisation().getName() + ".";
    }

    public boolean getShowOwnerInFooter() {
        return LicenseUtils.isShowOwnerInFooter(this.feLicense) || this.cruLicense != null && LicenseUtils.isShowOwnerInFooter(this.cruLicense);
    }

    private Long getLatestBuildAllowed() {
        Long b2;
        Long a2 = LicenseUtils.getLatestBuildAllowed(this.feLicense);
        Long l2 = b2 = this.cruLicense == null ? null : LicenseUtils.getLatestBuildAllowed(this.cruLicense);
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        return Math.min(a2, b2);
    }

    public Date getLatestBuildAllowedValue() {
        Long t2 = this.getLatestBuildAllowed();
        return t2 == null ? null : new Date(t2);
    }

    public boolean getShouldHassle() {
        return this.isFishEyeShouldHassle() || this.isCrucibleShouldHassle();
    }

    public boolean isFishEyeShouldHassle() {
        return this.feLicense != null && LicenseUtils.isShouldHassle(this.feLicense);
    }

    public boolean isCrucibleShouldHassle() {
        return this.cruLicense != null && LicenseUtils.isShouldHassle(this.cruLicense);
    }

    public boolean isFishEye() {
        return this.lh.hasFishEye();
    }

    public boolean isCrucible() {
        return this.lh.hasCrucible();
    }

    public boolean isCrucibleOnly() {
        return this.lh.isCrucibleOnly();
    }

    public boolean isFishEyeOnly() {
        return this.lh.hasFishEye() && !this.isCrucible();
    }

    public int getMaxCommitters() {
        return LicenseUtils.getIntProperty(this.feLicense, "fisheye.NumberOfCommitters", -1);
    }

    public int getMaxRepositories() {
        return LicenseUtils.getIntProperty(this.feLicense, "fisheye.NumberOfRepositories", -1);
    }

    public boolean isAllProductsInEval() {
        if (this.isCrucibleOnly()) {
            return this.getCrucibleLicense().isEvaluation();
        }
        if (this.isFishEyeOnly()) {
            return this.getFisheyeLicense().isEvaluation();
        }
        return this.getFisheyeLicense().isEvaluation() && this.getCrucibleLicense().isEvaluation();
    }
}

