/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.Contact;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.DateEditor;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.common.util.ProductLicenseProperties;
import com.atlassian.extras.core.LicenseManagerFactory;
import com.atlassian.extras.core.crucible.CrucibleProductLicenseFactory;
import com.atlassian.extras.core.fisheye.FisheyeProductLicenseFactory;
import com.cenqua.fisheye.license.LicenseUtils;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class LicenseHolder {
    public static final String SYNTHETIC_EVAL = "Evaluation";
    public static final String DISABLED = "Disabled";
    private static final FisheyeProductLicenseFactory feLicenseFactory = new FisheyeProductLicenseFactory();
    private static final CrucibleProductLicenseFactory cruLicenseFactory = new CrucibleProductLicenseFactory();
    private String feLicenseString;
    private String cruLicenseString;
    private ProductLicense feLicense;
    private ProductLicense cruLicense;
    private boolean syntheticFishEyeEval;
    private boolean syntheticCrucibleEval;
    private boolean crucibleOnly;

    public LicenseHolder() {
        this.syntheticFishEyeEval = false;
        this.syntheticCrucibleEval = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    LicenseHolder(String fishEyeLicenseString, String crucibleLicenseString) {
        block15: {
            this.syntheticFishEyeEval = false;
            this.syntheticCrucibleEval = false;
            if (crucibleLicenseString != null) {
                if (crucibleLicenseString.equals(SYNTHETIC_EVAL)) {
                    this.syntheticCrucibleEval = true;
                } else if (!crucibleLicenseString.equals(DISABLED)) {
                    this.cruLicenseString = crucibleLicenseString;
                }
            }
            if (fishEyeLicenseString != null) {
                if (fishEyeLicenseString.equals(SYNTHETIC_EVAL)) {
                    this.syntheticFishEyeEval = true;
                } else if (!fishEyeLicenseString.equals(DISABLED)) {
                    this.feLicenseString = fishEyeLicenseString;
                }
            }
            if (this.syntheticCrucibleEval && this.syntheticFishEyeEval) {
                Logs.APP_LOG.warn((Object)"Invalid license options: Need at least one valid license.");
                return;
            }
            if (this.syntheticCrucibleEval) {
                if (this.parseFishEyeLicense() && this.feLicense.isEvaluation()) {
                    this.makeSyntheticCrucibleLicense();
                    break block15;
                } else {
                    this.syntheticCrucibleEval = false;
                    return;
                }
            }
            this.parseCrucibleLicense();
        }
        if (this.syntheticFishEyeEval) {
            if (this.cruLicense == null) {
                this.syntheticFishEyeEval = false;
                return;
            }
            this.crucibleOnly = !this.cruLicense.isEvaluation();
            this.makeSyntheticFishEyeLicense();
            return;
        }
        if (fishEyeLicenseString != null && !fishEyeLicenseString.equals(DISABLED)) {
            if (this.feLicense != null) return;
            this.parseFishEyeLicense();
            return;
        }
        this.crucibleOnly = true;
        this.makeSyntheticFishEyeLicense();
    }

    public static LicenseHolder makeFishEyeLicenseWithCrucibleEval(String feString) {
        return LicenseHolder.makeFishEyeCrucibleLicense(feString, SYNTHETIC_EVAL);
    }

    public static LicenseHolder makeCrucibleLicenseWithFishEyeEval(String cruString) {
        return LicenseHolder.makeFishEyeCrucibleLicense(SYNTHETIC_EVAL, cruString);
    }

    public static LicenseHolder makeFishEyeOnlyLicense(String feString) {
        return LicenseHolder.makeFishEyeCrucibleLicense(feString, DISABLED);
    }

    public static LicenseHolder makeCrucibleOnlyLicense(String cruString) {
        return LicenseHolder.makeFishEyeCrucibleLicense(DISABLED, cruString);
    }

    public static LicenseHolder makeFishEyeCrucibleLicense(String feString, String cruString) {
        return new LicenseHolder(feString, cruString);
    }

    public boolean isSyntheticCrucibleEval() {
        return this.syntheticCrucibleEval;
    }

    public boolean isSyntheticFishEyeEval() {
        return this.syntheticFishEyeEval;
    }

    public ProductLicense getCrucibleLicense() {
        return this.cruLicense;
    }

    public String getCrucibleLicenseString() {
        return this.cruLicenseString;
    }

    public boolean isFishEyeDisabled() {
        return Strings.isNullOrEmpty((String)this.feLicenseString);
    }

    public boolean isCrucibleDisabled() {
        return Strings.isNullOrEmpty((String)this.cruLicenseString);
    }

    public ProductLicense getFishEyeLicense() {
        return this.feLicense;
    }

    public String getFishEyeLicenseString() {
        return this.feLicenseString;
    }

    public boolean hasFishEye() {
        return this.feLicense != null && !this.crucibleOnly;
    }

    public boolean hasCrucible() {
        return this.cruLicense != null;
    }

    public boolean canDecodeFishEye() {
        return this.feLicense != null;
    }

    public boolean canDecodeCrucible() {
        return this.cruLicense != null;
    }

    public boolean isFishEyeGracePeriodExpired() {
        return this.feLicense.isGracePeriodExpired();
    }

    public boolean isCrucibleGracePeriodExpired() {
        return this.cruLicense.isGracePeriodExpired();
    }

    public boolean isFishEyeValidForCurrentBuild() {
        return LicenseUtils.isValidForCurrentBuild(this.feLicense);
    }

    public boolean isCrucibleValidForCurrentBuild() {
        return LicenseUtils.isValidForCurrentBuild(this.cruLicense);
    }

    public boolean isCrucibleOnly() {
        return this.cruLicense != null && !this.hasFishEye();
    }

    private boolean parseFishEyeLicense() {
        if (!Strings.isNullOrEmpty((String)this.feLicenseString)) {
            try {
                AtlassianLicense license = LicenseManagerFactory.getLicenseManager().getLicense(this.feLicenseString);
                this.feLicense = license.getProductLicense(Product.FISHEYE);
                return true;
            }
            catch (RuntimeException e2) {
                Logs.APP_LOG.warn((Object)"FishEye license is invalid", (Throwable)e2);
            }
        }
        return false;
    }

    private boolean parseCrucibleLicense() {
        if (!Strings.isNullOrEmpty((String)this.cruLicenseString)) {
            try {
                AtlassianLicense license = LicenseManagerFactory.getLicenseManager().getLicense(this.cruLicenseString);
                this.cruLicense = license.getProductLicense(Product.CRUCIBLE);
                return true;
            }
            catch (RuntimeException e2) {
                Logs.APP_LOG.warn((Object)"Crucible license is invalid", (Throwable)e2);
            }
        }
        return false;
    }

    private void makeSyntheticFishEyeLicense() {
        try {
            if (this.cruLicense != null) {
                Properties props = new Properties();
                this.copyProps(props, this.cruLicense);
                this.feLicense = feLicenseFactory.getLicense(Product.FISHEYE, (LicenseProperties)new ProductLicenseProperties(Product.FISHEYE, props));
            }
        }
        catch (RuntimeException e2) {
            Logs.APP_LOG.warn((Object)"Error creating a FishEye evaluation", (Throwable)e2);
        }
        finally {
            if (this.feLicense == null) {
                this.syntheticFishEyeEval = false;
            }
        }
    }

    private void makeSyntheticCrucibleLicense() {
        try {
            if (this.feLicense != null) {
                Properties props = new Properties();
                this.copyProps(props, this.feLicense);
                this.cruLicense = cruLicenseFactory.getLicense(Product.CRUCIBLE, (LicenseProperties)new ProductLicenseProperties(Product.CRUCIBLE, props));
            }
        }
        catch (RuntimeException e2) {
            Logs.APP_LOG.warn((Object)"Error creating a Crucible evaluation", (Throwable)e2);
        }
        finally {
            if (this.cruLicense == null) {
                this.syntheticCrucibleEval = false;
            }
        }
    }

    private void copyProps(Properties props, ProductLicense license) {
        Iterator i2;
        this.propSet(props, "licenseVersion", Integer.toString(license.getLicenseVersion()));
        this.propSet(props, "Description", license.getDescription());
        this.propSet(props, SYNTHETIC_EVAL, Boolean.toString(license.isEvaluation()));
        this.propSet(props, "Subscription", Boolean.toString(license.isSubscription()));
        this.propSet(props, "ServerID", license.getServerId());
        if (license.getPartner() != null) {
            this.propSet(props, "PartnerName", license.getPartner().getName());
        }
        if (license.getOrganisation() != null) {
            this.propSet(props, "Organisation", license.getOrganisation().getName());
        }
        if ((i2 = license.getContacts().iterator()).hasNext()) {
            Contact c2 = (Contact)i2.next();
            this.propSet(props, "ContactEMail", c2.getEmail());
            this.propSet(props, "ContactName", c2.getName());
        }
        props.put("CreationDate", DateEditor.getString((Date)license.getCreationDate()));
        if (license.getExpiryDate() != null) {
            props.put("LicenseExpiryDate", DateEditor.getString((Date)license.getExpiryDate()));
            if (license.getGracePeriodEndDate() != null) {
                long termination = license.getGracePeriodEndDate().getTime();
                long expiration = license.getExpiryDate().getTime();
                props.put("GracePeriod", Long.toString((termination - expiration) / 86400000L));
            } else {
                props.put("GracePeriod", "unlimited");
            }
        } else {
            props.put("LicenseExpiryDate", "unlimited");
            props.put("GracePeriod", "unlimited");
        }
        if (license.getMaintenanceExpiryDate() != null) {
            props.put("MaintenanceExpiryDate", DateEditor.getString((Date)license.getMaintenanceExpiryDate()));
        } else {
            props.put("MaintenanceExpiryDate", "unlimited");
        }
        this.propSet(props, "SEN", license.getSupportEntitlementNumber());
        if (license.isUnlimitedNumberOfUsers()) {
            this.propSet(props, "NumberOfUsers", "-1");
        } else {
            this.propSet(props, "NumberOfUsers", Integer.toString(license.getMaximumNumberOfUsers()));
        }
        this.propSet(props, "LicenseTypeName", license.getLicenseType().name());
    }

    private void propSet(Properties props, String propName, String value) {
        if (value != null) {
            props.put(propName, value);
        }
    }
}

