/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.RandomAccessIOStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class Utf16ERandomAccessIoStream
implements RandomAccessIOStream {
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    private final RandomAccessIOStream mIn;

    public Utf16ERandomAccessIoStream(RandomAccessIOStream in) {
        this.mIn = in;
    }

    @Override
    public void seek(long fp) throws IOException {
        this.mIn.seek(fp * 2L);
    }

    @Override
    public int read() throws IOException {
        int clow = this.mIn.read();
        int chigh = this.mIn.read();
        int c2 = chigh << 8 | clow;
        return c2;
    }

    @Override
    public long getFilePointer() {
        return this.mIn.getFilePointer() / 2L;
    }

    @Override
    public long length() throws IOException {
        return this.mIn.length() / 2L;
    }

    @Override
    public void close() throws IOException {
        this.mIn.close();
    }
}

