/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.IndexedLineReader;
import java.io.IOException;
import java.util.List;

public class StringIndexedLineReader
implements IndexedLineReader {
    private List<String> lines;
    private int currentLine = 0;
    private int length;

    public StringIndexedLineReader(List<String> lines) {
        for (String s2 : lines) {
            this.length += s2.length();
        }
        this.lines = lines;
    }

    @Override
    public String readline() throws IOException {
        if (this.currentLine >= this.lines.size()) {
            return null;
        }
        String s2 = this.lines.get(this.currentLine);
        ++this.currentLine;
        return s2;
    }

    @Override
    public int getLineNumber() {
        return this.currentLine;
    }

    @Override
    public int readline(StringBuffer aBuf) throws IOException {
        String s2 = this.readline();
        if (s2 == null) {
            return -1;
        }
        aBuf.append(s2);
        return s2.length();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getTotalLines() {
        return this.lines.size();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void seekLine(int lineno) throws IOException {
        this.currentLine = lineno;
    }

    @Override
    public void scanRestOfFile() throws IOException {
    }

    @Override
    public CharSequence getCharSequence() {
        StringBuilder sb = new StringBuilder(this.length);
        for (String s2 : this.lines) {
            sb.append(s2);
        }
        return sb.toString();
    }

    @Override
    public int getOffsetForLine(int lineno) {
        if (lineno == this.lines.size()) {
            return this.length;
        }
        int offset = 0;
        for (int i2 = 0; i2 < lineno; ++i2) {
            offset += this.lines.get(i2).length();
        }
        return offset;
    }

    @Override
    public boolean isEolTerminated() throws IOException {
        return this.lines.get(this.lines.size() - 1).endsWith("\n");
    }

    @Override
    public void dispose() throws Exception {
    }
}

