/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.cvsrep.StringFileChunk;
import com.cenqua.fisheye.io.FilePointerStream;
import com.cenqua.fisheye.io.LineReader;
import java.io.IOException;

public class StreamLineReader
extends LineReader {
    private final FilePointerStream mIn;

    public StreamLineReader(FilePointerStream in) {
        this.mIn = in;
    }

    public StreamLineReader(LineReader.Mode fileMode, FilePointerStream mIn) {
        super(fileMode);
        this.mIn = mIn;
    }

    @Override
    protected int read() throws IOException {
        return this.mIn.read();
    }

    @Override
    public void close() throws IOException {
        this.mIn.close();
    }

    public StringFileChunk readLineWithOffsets() throws IOException {
        long fpStart = this.getFilePosition();
        String text = this.readLine();
        if (text == null) {
            return null;
        }
        return new StringFileChunk(fpStart, text, this.getFilePosition());
    }

    private long getFilePosition() {
        return this.mIn.getFilePointer() + (long)this.getBufferSize();
    }
}

