/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.BufferedCharSequence;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.RandomAccessIOStream;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Disposable;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class StreamIndexedLineReader
implements IndexedLineReader,
Disposable {
    private final RandomAccessIOStream mFile;
    private final String path;
    private final LongArrayList mIndexes = new LongArrayList();
    private boolean scanned = false;
    private int mCurrentLineNumber = 0;
    private long fileLength = -1L;

    public StreamIndexedLineReader(RandomAccessIOStream aFile, String path) {
        this.mFile = aFile;
        this.mIndexes.add(this.mFile.getFilePointer());
        this.path = path;
    }

    public StreamIndexedLineReader(RandomAccessIOStream aFile) {
        this(aFile, null);
    }

    public StreamIndexedLineReader(File aFile) throws FileNotFoundException {
        this(new BufferedRandomAccessInputStream(aFile));
    }

    @Override
    public String readline() throws IOException {
        StringBuffer buf = new StringBuffer();
        int nread = this.readline(buf);
        if (nread == -1) {
            return null;
        }
        return buf.toString();
    }

    @Override
    public int getLineNumber() {
        return this.mCurrentLineNumber;
    }

    @Override
    public int readline(StringBuffer aBuf) throws IOException {
        boolean atEOF;
        int c2;
        int nread = 0;
        while ((c2 = this.mFile.read()) != -1) {
            ++nread;
            aBuf.append((char)c2);
            if (c2 == 13) {
                int c22 = this.mFile.read();
                if (c22 == 10) {
                    ++nread;
                    aBuf.append((char)c22);
                    break;
                }
                if (c22 == -1) break;
                this.mFile.seek(this.mFile.getFilePointer() - 1L);
                break;
            }
            if (c2 != 10) continue;
        }
        if (nread == 0) {
            return -1;
        }
        long fp = this.mFile.getFilePointer();
        boolean bl = atEOF = fp == this.getFileLength();
        if (atEOF) {
            return nread;
        }
        ++this.mCurrentLineNumber;
        if (this.mCurrentLineNumber >= this.mIndexes.size()) {
            this.mIndexes.add(fp);
        }
        return nread;
    }

    private long getFileLength() throws IOException {
        if (this.fileLength == -1L) {
            this.fileLength = this.mFile.length();
        }
        return this.fileLength;
    }

    @Override
    public void close() throws IOException {
        this.mFile.close();
    }

    @Override
    public void dispose() throws Exception {
        this.close();
    }

    @Override
    public int getTotalLines() {
        return this.mIndexes.size();
    }

    @Override
    public int length() {
        try {
            return (int)this.mFile.length();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void seekLine(int lineno) throws IOException {
        long fp = this.guardLineNumber(lineno) ? this.mIndexes.getLong(lineno) : this.mIndexes.getLong(this.mIndexes.size() - 1);
        this.mFile.seek(fp);
        this.mCurrentLineNumber = lineno;
    }

    @Override
    public void scanRestOfFile() throws IOException {
        this.scanRestOfFile(new StringBuffer());
    }

    private void scanRestOfFile(StringBuffer buf) throws IOException {
        if (!this.scanned) {
            buf.setLength(0);
            while (this.readline(buf) != -1) {
                buf.setLength(0);
            }
            this.scanned = true;
        }
    }

    @Override
    public CharSequence getCharSequence() {
        return new BufferedCharSequence(this.mFile);
    }

    @Override
    public int getOffsetForLine(int lineno) {
        if (lineno == this.mIndexes.size()) {
            return this.length();
        }
        if (this.guardLineNumber(lineno)) {
            return (int)this.mIndexes.getLong(lineno);
        }
        return this.length();
    }

    @Override
    public boolean isEolTerminated() throws IOException {
        long len = this.mFile.length();
        if (len == 0L) {
            return false;
        }
        this.mFile.seek(len - 1L);
        int c2 = this.mFile.read();
        return c2 == 10 || c2 == 13;
    }

    private boolean guardLineNumber(int lineno) {
        if (lineno >= this.mIndexes.size()) {
            String msg = String.format("unknown line number %d only know about %d in %s", lineno, this.getTotalLines(), this.path == null ? "" : this.path);
            Logs.APP_LOG.warn((Object)msg);
            if (Logs.isDebugMode()) {
                List<StackTraceElement> stack = Arrays.asList(new Throwable().getStackTrace()).subList(1, 8);
                StringBuilder stacktraceMsg = new StringBuilder();
                for (StackTraceElement s2 : stack) {
                    stacktraceMsg.append("--> ").append(s2.toString()).append("\n");
                }
                Logs.APP_LOG.debug((Object)String.format("%s\n%s", msg, stacktraceMsg));
            }
            return false;
        }
        return true;
    }
}

