/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.IOHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class OutputStreamBuffer
extends OutputStream {
    private static int DEFAULT_SIZE = 8192;
    private long position;
    private byte[] buffer;
    private File diskFile;
    private OutputStream disk;
    private boolean open;

    public OutputStreamBuffer() throws IOException {
        this(DEFAULT_SIZE);
    }

    public OutputStreamBuffer(int size) throws IOException {
        this.buffer = new byte[size];
        this.open = true;
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.position >= (long)this.buffer.length) {
            if (this.disk == null) {
                this.diskInit();
            }
            this.disk.write(b2, off, len);
            this.position += (long)len;
        } else {
            int copy = Math.min(this.buffer.length - (int)this.position, len);
            System.arraycopy(b2, off, this.buffer, (int)this.position, copy);
            this.position += (long)copy;
            if (copy < len) {
                this.write(b2, off + copy, len - copy);
            }
        }
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.position >= (long)this.buffer.length) {
            if (this.disk == null) {
                this.diskInit();
            }
            this.disk.write(b2);
        } else {
            this.buffer[(int)this.position] = (byte)b2;
        }
        ++this.position;
    }

    private void diskInit() throws IOException {
        this.diskFile = File.createTempFile("fisheye", "_iobuf");
        this.disk = new BufferedOutputStream(new FileOutputStream(this.diskFile));
    }

    @Override
    public void close() throws IOException {
        if (this.disk != null) {
            this.disk.close();
        }
        this.open = false;
    }

    @Override
    public void flush() throws IOException {
        if (this.disk != null) {
            this.disk.flush();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.open) {
            throw new IllegalStateException("can't read from the buffer while it is still open.");
        }
        return new BufferInputStream(this.buffer, this.diskFile, this.position);
    }

    public void dispose() throws IOException {
        if (this.diskFile != null) {
            this.diskFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAndStream(Writer out, String charset) throws IOException {
        try {
            this.close();
            InputStreamReader in = new InputStreamReader(this.getInputStream(), charset);
            IOHelper.copyReader(in, out);
            ((Reader)in).close();
            out.flush();
        }
        finally {
            this.dispose();
        }
    }

    static class BufferInputStream
    extends InputStream {
        private long size;
        private long position;
        private byte[] buffer;
        private InputStream disk;

        BufferInputStream(byte[] buffer, File diskFile, long size) throws IOException {
            this.buffer = buffer;
            this.size = size;
            this.position = 0L;
            if (size > (long)buffer.length) {
                this.disk = new BufferedInputStream(new FileInputStream(diskFile));
            }
        }

        @Override
        public int read() throws IOException {
            if (this.position == this.size) {
                return -1;
            }
            if (this.position >= (long)this.buffer.length) {
                int b2 = this.disk.read();
                if (b2 >= 0) {
                    ++this.position;
                }
                return b2;
            }
            return this.buffer[(int)this.position++] & 0xFF;
        }

        @Override
        public int read(byte[] b2) throws IOException {
            return this.read(b2, 0, b2.length);
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            int read;
            if (this.position == this.size) {
                return -1;
            }
            int sent = 0;
            if (this.position < (long)this.buffer.length) {
                sent = (int)Math.min((long)len, Math.min(this.size - this.position, (long)this.buffer.length - this.position));
                System.arraycopy(this.buffer, (int)this.position, b2, off, sent);
                this.position += (long)sent;
            }
            if (sent < len && this.size > (long)this.buffer.length && (read = this.disk.read(b2, off + sent, len - sent)) > 0) {
                this.position += (long)read;
                sent += read;
            }
            return sent;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() throws IOException {
            if (this.disk != null) {
                this.disk.close();
            }
        }
    }
}

