/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.atlassian.utils.process.LineReadable;
import java.io.IOException;
import java.util.LinkedList;

public abstract class LineReader
implements LineReadable {
    private final StringBuffer mBuf = new StringBuffer();
    private LinkedList<String> lineBuffer = new LinkedList();
    private int readAhead = -1;
    private Mode fileMode = Mode.MODE_DETECT;

    protected LineReader(Mode fileMode) {
        this.fileMode = fileMode;
    }

    protected LineReader() {
        this(Mode.MODE_DETECT);
    }

    private boolean isEOL(int i2) throws IOException {
        boolean isEOL;
        switch (this.fileMode) {
            case MODE_UNIX: {
                isEOL = i2 == 10;
                break;
            }
            case MODE_MAC: {
                isEOL = i2 == 13;
                break;
            }
            case MODE_PC: {
                if (i2 == 13) {
                    int i22 = this.readNext();
                    if (i22 == 10) {
                        this.mBuf.append((char)i22);
                        isEOL = true;
                        break;
                    }
                    this.pushBack(i22);
                    isEOL = false;
                    break;
                }
                isEOL = false;
                break;
            }
            case MODE_DETECT: {
                if (i2 == 10) {
                    this.fileMode = Mode.MODE_UNIX;
                    isEOL = true;
                    break;
                }
                if (i2 == 13) {
                    int i23 = this.readNext();
                    if (i23 == 10) {
                        this.mBuf.append((char)i23);
                        this.fileMode = Mode.MODE_PC;
                        isEOL = true;
                        break;
                    }
                    this.pushBack(i23);
                    this.fileMode = Mode.MODE_MAC;
                    isEOL = true;
                    break;
                }
                isEOL = false;
                break;
            }
            case MODE_MIXED: {
                if (i2 == 10) {
                    isEOL = true;
                    break;
                }
                if (i2 == 13) {
                    int i24 = this.readNext();
                    if (i24 == 10) {
                        this.mBuf.append((char)i24);
                        isEOL = true;
                        break;
                    }
                    this.pushBack(i24);
                    isEOL = true;
                    break;
                }
                isEOL = false;
                break;
            }
            case MODE_PC_UNIX_MIXED: {
                if (i2 == 10) {
                    isEOL = true;
                    break;
                }
                if (i2 == 13) {
                    int i25 = this.readNext();
                    if (i25 == 10) {
                        this.mBuf.append((char)i25);
                        isEOL = true;
                        break;
                    }
                    this.pushBack(i25);
                    isEOL = false;
                    break;
                }
                isEOL = false;
                break;
            }
            default: {
                isEOL = false;
            }
        }
        return isEOL;
    }

    public String readLine() throws IOException {
        if (this.lineBuffer.size() > 0) {
            return this.lineBuffer.removeFirst();
        }
        this.mBuf.setLength(0);
        int i2 = this.readNext();
        if (i2 == -1) {
            return null;
        }
        while (i2 != -1) {
            this.mBuf.append((char)i2);
            if (this.isEOL(i2)) break;
            i2 = this.readNext();
        }
        return this.mBuf.toString();
    }

    public String readLine(int maxLength) throws IOException {
        if (this.lineBuffer.size() > 0) {
            String line = this.lineBuffer.removeFirst();
            if (line.length() > maxLength) {
                return line.substring(0, maxLength);
            }
            return line;
        }
        this.mBuf.setLength(0);
        int i2 = this.readNext();
        if (i2 == -1) {
            return null;
        }
        while (i2 != -1) {
            if (this.mBuf.length() < maxLength) {
                this.mBuf.append((char)i2);
            }
            if (this.isEOL(i2)) break;
            i2 = this.readNext();
        }
        return this.mBuf.toString();
    }

    public void pushLineBack(String line) {
        this.lineBuffer.addFirst(line);
    }

    private int readNext() throws IOException {
        int ch;
        if (this.readAhead == -1) {
            ch = this.read();
        } else {
            ch = this.readAhead;
            this.readAhead = -1;
        }
        return ch;
    }

    private void pushBack(int ch) {
        this.readAhead = ch;
    }

    protected int getBufferSize() {
        if (this.readAhead == -1) {
            return 0;
        }
        return 1;
    }

    protected abstract int read() throws IOException;

    public abstract void close() throws IOException;

    public static enum Mode {
        MODE_DETECT,
        MODE_UNIX,
        MODE_MAC,
        MODE_PC,
        MODE_MIXED,
        MODE_PC_UNIX_MIXED;

    }
}

