/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.CharSequenceReader;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileDeleteStrategy;

public class IOHelper {
    public static void close(Closeable ... closeable) {
        if (closeable != null) {
            for (Closeable c2 : closeable) {
                if (c2 == null) continue;
                try {
                    c2.close();
                }
                catch (Exception e2) {
                    Logs.APP_LOG.info((Object)("problem closing resource: " + c2), (Throwable)e2);
                }
            }
        }
    }

    public static void copyDir(File fromDir, File toDir) throws IOException {
        if (fromDir.getCanonicalPath().equals(toDir.getCanonicalPath())) {
            return;
        }
        toDir.mkdirs();
        File[] entries = fromDir.listFiles();
        if (entries != null) {
            for (File entry : entries) {
                File dest = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    IOHelper.copyDir(entry, dest);
                    continue;
                }
                IOHelper.copy(entry, dest);
            }
        }
    }

    public static boolean rename(File src, File dest) throws IOException {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("arguments to rename cannot be null");
        }
        return src.renameTo(dest);
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.getCanonicalPath().equals(dest.getCanonicalPath())) {
            return;
        }
        if (dest.exists() && dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        FileOutputStream out = new FileOutputStream(dest);
        try {
            IOHelper.copyStream(src, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(out);
    }

    public static void copyStream(InputStream is, File dest) throws IOException {
        FileOutputStream fos = new FileOutputStream(dest);
        try {
            IOHelper.copyStream(is, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOHelper.close(is);
            IOHelper.close(fos);
            throw throwable;
        }
        IOHelper.close(is);
        IOHelper.close(fos);
    }

    public static void copyStream(File srcFile, OutputStream dest) throws IOException {
        FileInputStream in = new FileInputStream(srcFile);
        try {
            IOHelper.copyStream((InputStream)in, dest);
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
    }

    public static void copyStream(InputStream src, OutputStream dest) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            dest.write(buffer, 0, count);
        } while ((count = src.read(buffer, 0, buffer.length)) != -1);
    }

    public static void copyReader(Reader src, Writer dest) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        do {
            dest.write(buffer, 0, count);
        } while ((count = src.read(buffer, 0, buffer.length)) != -1);
    }

    public static String copyReaderToString(Reader src) throws IOException {
        StringWriter dest = new StringWriter();
        IOHelper.copyReader(src, dest);
        return dest.toString();
    }

    public static void copyStringToWriter(String src, Writer dest) throws IOException {
        IOHelper.copyReader(new StringReader(src), dest);
    }

    public static void copyCharSequenceToWriter(CharSequence src, Writer dest) throws IOException {
        IOHelper.copyReader(new CharSequenceReader(src), dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyFileToString(Charset charset, File file) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);){
            String string = IOHelper.copyReaderToString(reader);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStringToFile(String src, Charset charset, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
            IOHelper.copyStringToWriter(src, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyCharSequenceToFile(CharSequence src, Charset charset, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
            IOHelper.copyCharSequenceToWriter(src, writer);
        }
    }

    public static void recursiveDelete(File dir, int maxRecurse, boolean deleteThisDir) {
        IOHelper.recursiveDeleteImpl(dir, 0, maxRecurse, deleteThisDir);
    }

    public static void recursiveDelete(File dir, int maxRecurse) {
        IOHelper.recursiveDeleteImpl(dir, 0, maxRecurse, true);
    }

    private static void recursiveDeleteImpl(File dir, int currentRecurse, int maxRecurse, boolean deleteThisDir) {
        if (currentRecurse > maxRecurse) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Logs.APP_LOG.debug((Object)("deleting " + files.length + " file/dir in " + dir));
        for (File file : files) {
            if (file.isFile()) {
                if (file.delete()) continue;
                Logs.APP_LOG.warn((Object)("problem deleting " + file));
                continue;
            }
            if (!file.isDirectory()) continue;
            IOHelper.recursiveDeleteImpl(file, currentRecurse + 1, maxRecurse, true);
        }
        if (deleteThisDir && !dir.delete()) {
            Logs.APP_LOG.warn((Object)("problem deleting directory " + dir));
        }
    }

    public static void copyStream(Reader in, Writer out) throws IOException {
        int c2;
        while (-1 != (c2 = in.read())) {
            out.write(c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translateEncodings(File srcFile, Charset srcEnc, File destFile, Charset destEnc) throws IOException {
        BufferedReader in2 = null;
        BufferedWriter out = null;
        try {
            in2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), srcEnc));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), destEnc));
            IOHelper.copyStream(in2, out);
        }
        catch (Throwable throwable) {
            IOHelper.close(in2);
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(in2);
        IOHelper.close(out);
    }

    public static boolean mkdirs(File dir) throws IOException {
        if (dir != null) {
            boolean result = dir.mkdirs();
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IOException("Could not create directory: " + dir);
            }
            return result;
        }
        return false;
    }

    public static boolean createNewFile(File file) throws IOException {
        try {
            return file.createNewFile();
        }
        catch (IOException e2) {
            throw new IOException(e2.getMessage() + " - " + file.getAbsolutePath());
        }
    }

    public static void deleteFile(File file) {
        if (file != null && file.exists() && !file.delete()) {
            Logs.APP_LOG.warn((Object)("Unable to delete file: " + file));
        }
    }

    public static void deleteFiles(@Nonnull File parentDir, final @Nonnull FileFilter fileFilter, final @Nonnull FileDeleteStrategy deleteStrategy) {
        FileFilter deleteFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (fileFilter.accept(file)) {
                    deleteStrategy.deleteQuietly(file);
                }
                return false;
            }
        };
        parentDir.listFiles(deleteFileFilter);
    }

    public static void deleteFiles(@Nonnull File parentDir, @Nonnull FileFilter fileFilter) {
        IOHelper.deleteFiles(parentDir, fileFilter, FileDeleteStrategy.NORMAL);
    }

    public static void unzip(File zipFile, File dir) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> e2 = zf.entries();
        while (e2.hasMoreElements()) {
            ZipEntry entry = e2.nextElement();
            String name = entry.getName();
            File entryFile = new File(dir, name);
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            entryFile.getParentFile().mkdirs();
            InputStream stream = zf.getInputStream(entry);
            IOHelper.copyStream(stream, entryFile);
        }
    }

    public static void write(FileWriter addedLineWriter, String s2) throws IOException {
        addedLineWriter.write(s2);
    }

    public static void write(OutputStream addedByteWriter, byte b2) throws IOException {
        addedByteWriter.write(b2);
    }

    public static void deleteIfEmpty(File file) {
        if (file != null && file.isFile() && file.length() == 0L) {
            file.delete();
        }
    }

    public static boolean touch(File journalFile) throws IOException {
        if (journalFile.exists()) {
            return journalFile.setLastModified(System.currentTimeMillis());
        }
        return journalFile.createNewFile();
    }

    public static void clearDir(File dir) {
        if (dir != null) {
            IOHelper.recursiveDeleteImpl(dir, 0, 100, false);
        }
    }

    public static boolean isSameFile(File a2, File b2) {
        try {
            a2 = a2.getCanonicalFile();
            b2 = b2.getCanonicalFile();
        }
        catch (IOException e2) {
            a2 = a2.getAbsoluteFile();
            b2 = b2.getAbsoluteFile();
        }
        return a2.equals(b2);
    }

    public static File ensureDirectoryExists(File dir) {
        try {
            IOHelper.mkdirs(dir);
        }
        catch (IOException e2) {
            throw new RuntimeException("Couldn't create directory " + dir.getAbsolutePath(), e2);
        }
        return dir;
    }

    public static File ensureDirectoryExists(File location, String subdir) {
        return IOHelper.ensureDirectoryExists(new File(location, subdir));
    }
}

