/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.RandomAccessIOStream;
import java.io.IOException;

public class BufferedCharSequence
implements CharSequence {
    private int start;
    private int end;
    private RandomAccessIOStream input;

    public BufferedCharSequence(RandomAccessIOStream input) {
        try {
            this.input = input;
            this.start = 0;
            this.end = (int)input.length();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public BufferedCharSequence(RandomAccessIOStream input, int start, int end) {
        try {
            this.guardSubSequence(start, end, (int)input.length());
            this.input = input;
            this.start = start;
            this.end = end;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.input.seek(this.start + index);
            return (char)this.input.read();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public CharSequence subSequence(int substart, int subend) {
        this.guardSubSequence(substart, subend, this.length());
        return new BufferedCharSequence(this.input, this.start + substart, this.start + subend);
    }

    @Override
    public String toString() {
        try {
            StringBuffer buf = new StringBuffer(this.length());
            this.input.seek(this.start);
            for (int i2 = 0; i2 < this.length(); ++i2) {
                buf.append((char)this.input.read());
            }
            return buf.toString();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void guardSubSequence(int start, int end, int length) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start index " + start + " < 0");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end index " + end + " < 0");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start index " + start + " > end index " + end);
        }
        if (end > length) {
            throw new IndexOutOfBoundsException("end index " + end + " > length " + length);
        }
    }
}

