/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.infinitydb.query3.Query3Params;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.IndexSearcher;

public abstract class Query3 {
    public ac asItemSpace(final Query3Params query3Params) throws DbException {
        boolean withCrossRepoLucene;
        EnumSet<LuceneIndexes> requiredPerRepoReaders = EnumSet.noneOf(LuceneIndexes.class);
        this.calculateRequiredPerRepoReaders(requiredPerRepoReaders);
        boolean withPerRepoLucene = !requiredPerRepoReaders.isEmpty();
        final EnumSet<CrossRepLuceneIndexes> requiredCrossRepoReaders = EnumSet.noneOf(CrossRepLuceneIndexes.class);
        this.calculateRequiredCrossRepoReaders(requiredCrossRepoReaders);
        boolean bl = withCrossRepoLucene = !requiredCrossRepoReaders.isEmpty();
        if (withPerRepoLucene && query3Params.getPerRepoConnection() == null) {
            throw new DbException("Query requires lucene but no per-repo connection given: " + this.toString());
        }
        if (withCrossRepoLucene && query3Params.getCrossRepoConnection() == null) {
            throw new DbException("Query requires lucene but no cross-repo connection given: " + this.toString());
        }
        final Query3 q2 = this.simplify();
        if (!withPerRepoLucene && !withCrossRepoLucene) {
            return q2.asItemSpace(new QueryContext(query3Params.getSource(), query3Params.getCommonStringTables(), null));
        }
        final AtomicReference result = new AtomicReference();
        if (withPerRepoLucene && !withCrossRepoLucene) {
            query3Params.getPerRepoConnection().withIndexSearchers(requiredPerRepoReaders, new LuceneConnection.IndexSearcherActionN<LuceneIndexes>(){

                @Override
                public void perform(Map<LuceneIndexes, IndexSearcher> searchers) throws DbException {
                    result.set(q2.asItemSpace(new QueryContext(query3Params.getSource(), query3Params.getCommonStringTables(), searchers)));
                }
            });
        } else if (!withPerRepoLucene) {
            query3Params.getCrossRepoConnection().withIndexSearchers(requiredCrossRepoReaders, new LuceneConnection.IndexSearcherActionN<CrossRepLuceneIndexes>(){

                @Override
                public void perform(Map<CrossRepLuceneIndexes, IndexSearcher> searchers) throws DbException {
                    result.set(q2.asItemSpace(new QueryContext(query3Params.getSource(), query3Params.getCommonStringTables(), searchers)));
                }
            });
        } else {
            query3Params.getPerRepoConnection().withIndexSearchers(requiredPerRepoReaders, new LuceneConnection.IndexSearcherActionN<LuceneIndexes>(){

                @Override
                public void perform(final Map<LuceneIndexes, IndexSearcher> perRepoSearchers) throws DbException {
                    query3Params.getCrossRepoConnection().withIndexSearchers(requiredCrossRepoReaders, new LuceneConnection.IndexSearcherActionN<CrossRepLuceneIndexes>(){

                        @Override
                        public void perform(Map<CrossRepLuceneIndexes, IndexSearcher> crossRepoSearchers) throws DbException {
                            ImmutableMap searchers = ImmutableMap.builder().putAll(perRepoSearchers).putAll(crossRepoSearchers).build();
                            result.set(q2.asItemSpace(new QueryContext(query3Params.getSource(), query3Params.getCommonStringTables(), (Map<? extends LuceneConnection.IndexConfig, IndexSearcher>)searchers)));
                        }
                    });
                }
            });
        }
        return (ac)result.get();
    }

    protected void calculateRequiredPerRepoReaders(EnumSet<LuceneIndexes> requiredReaders) {
    }

    protected void calculateRequiredCrossRepoReaders(EnumSet<CrossRepLuceneIndexes> requiredReaders) {
    }

    protected abstract ac asItemSpace(QueryContext var1) throws DbException;

    public boolean existAny(Query3Params query3Params) throws DbException {
        try {
            ac result = this.asItemSpace(query3Params);
            y cu = y.a();
            return result.d(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        this.toString(s2);
        return s2.toString();
    }

    public abstract void toString(StringBuffer var1);

    public Query3 simplify() {
        return this;
    }

    public static SortedIntSet makeBitSet() {
        return new SegmentedIntSet();
    }

    public static class QueryContext {
        private ac source;
        private CommonStringTables stringTables;
        private Map<? extends LuceneConnection.IndexConfig, IndexSearcher> indexSearchers;

        public QueryContext(ac source, CommonStringTables stringTables, Map<? extends LuceneConnection.IndexConfig, IndexSearcher> indexSearchers) {
            this.source = source;
            this.stringTables = stringTables;
            this.indexSearchers = indexSearchers;
        }

        public ac getSource() {
            return this.source;
        }

        public CommonStringTables getStringTables() {
            return this.stringTables;
        }

        public Map<? extends LuceneConnection.IndexConfig, IndexSearcher> getIndexSearchers() {
            return this.indexSearchers;
        }
    }
}

