/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.infinitydb.a;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.lucene.NonOrderedCollector;
import com.cenqua.fisheye.lucene.join.DocumentRightJoinEnum;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.ac;
import java.io.IOException;
import java.util.BitSet;
import java.util.EnumSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class PerRepoLuceneJoinQuery3
extends Query3 {
    private final Query luceneQuery;
    private final LuceneIndexes requiredIndex;

    public PerRepoLuceneJoinQuery3(Query luceneQuery, LuceneIndexes requiredIndex) {
        this.luceneQuery = luceneQuery;
        this.requiredIndex = requiredIndex;
    }

    @Override
    protected void calculateRequiredPerRepoReaders(EnumSet<LuceneIndexes> requiredReaders) {
        requiredReaders.add(this.requiredIndex);
    }

    @Override
    protected ac asItemSpace(Query3.QueryContext context) throws DbException {
        try {
            IndexSearcher indexSearcher = context.getIndexSearchers().get(this.requiredIndex);
            IndexReader indexReader = indexSearcher.getIndexReader();
            final BitSet docids = new BitSet(indexReader.maxDoc());
            indexSearcher.search(this.luceneQuery, (Collector)new NonOrderedCollector(){

                @Override
                public void collectDocId(int doc) {
                    docids.set(doc);
                }
            });
            DocumentRightJoinEnum revidEnum = new DocumentRightJoinEnum(indexReader, "revid", docids);
            revidEnum.reset();
            SortedIntSet revids = PerRepoLuceneJoinQuery3.makeBitSet();
            while (revidEnum.hasNext()) {
                Term term = revidEnum.term();
                revids.set(Integer.parseInt(term.text()));
            }
            return new a(revids);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append("Lucene(").append(this.luceneQuery).append(")");
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        PerRepoLuceneJoinQuery3 that = (PerRepoLuceneJoinQuery3)o2;
        return this.requiredIndex == that.requiredIndex && this.luceneQuery.equals((Object)that.luceneQuery);
    }

    @Override
    public int hashCode() {
        int result = this.luceneQuery.hashCode();
        result = 29 * result + this.requiredIndex.hashCode();
        return result;
    }
}

