/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.infinitydb.a;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.NonOrderedCollector;
import com.cenqua.fisheye.lucene.join.LeftJoinQuery;
import com.cenqua.fisheye.lucene.join.RightJoinEnum;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.BitSet;
import java.util.EnumSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class CrossRepoLuceneJoinQuery3
extends Query3 {
    private final Query luceneQuery;
    private final CrossRepLuceneIndexes requiredIndex;

    public CrossRepoLuceneJoinQuery3(Query luceneQuery, CrossRepLuceneIndexes requiredIndex) {
        this.luceneQuery = luceneQuery;
        this.requiredIndex = requiredIndex;
    }

    @Override
    protected void calculateRequiredCrossRepoReaders(EnumSet<CrossRepLuceneIndexes> requiredReaders) {
        requiredReaders.add(this.requiredIndex);
    }

    @Override
    protected ac asItemSpace(Query3.QueryContext context) throws DbException {
        try {
            IndexSearcher indexSearcher = context.getIndexSearchers().get(this.requiredIndex);
            IndexReader indexReader = indexSearcher.getIndexReader();
            final BitSet docids = new BitSet(indexReader.maxDoc());
            indexSearcher.search(this.luceneQuery, (Collector)new NonOrderedCollector(){

                @Override
                public void collectDocId(int doc) {
                    docids.set(doc);
                }
            });
            RightJoinEnum csidEnum = LeftJoinQuery.makeRightEnum(docids, indexReader, "csid");
            SortedIntSet revIds = this.getRevIds(context.getSource(), csidEnum);
            return new a(revIds);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private SortedIntSet getRevIds(ac db, RightJoinEnum csIds) throws IOException {
        csIds.reset();
        SegmentedIntSet result = new SegmentedIntSet();
        y cu = y.a().a(CommonSchema.E_CSID_TO_REVID);
        int keyLength = cu.e();
        while (csIds.hasNext()) {
            cu.b(csIds.term().text());
            int csKeyLength = cu.e();
            while (db.a(cu, csKeyLength)) {
                int revId = (int)cu.v(csKeyLength);
                result.set(revId);
            }
            cu.d(keyLength);
        }
        return result;
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append("Lucene(").append(this.luceneQuery).append(")");
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CrossRepoLuceneJoinQuery3 that = (CrossRepoLuceneJoinQuery3)o2;
        return this.requiredIndex == that.requiredIndex && this.luceneQuery.equals((Object)that.luceneQuery);
    }

    @Override
    public int hashCode() {
        int result = this.luceneQuery.hashCode();
        result = 29 * result + this.requiredIndex.hashCode();
        return result;
    }
}

