/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.AbstractUniqueStringTable;
import com.cenqua.fisheye.infinitydb.CuPool;
import com.cenqua.fisheye.infinitydb.IdCollector;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.u;
import com.cenqua.obfuscate.idb.v;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UniqueStringTableImpl
extends AbstractUniqueStringTable {
    private static final p CURRENT_ID = new p(0L);
    private static final p PRIMARY = new p(1L);
    private static final p SECONDARY = new p(2L);
    private final Object ID_LOCK = new Object();
    private final InfinityDbHandle dbh;
    private final I tableClass;

    public UniqueStringTableImpl(InfinityDbHandle dbh, I table) {
        this.dbh = dbh;
        this.tableClass = table;
    }

    @Override
    public I getTableId() {
        return this.tableClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get(long id) throws DbException {
        if (id == 0L) {
            return null;
        }
        try {
            y cu = CuPool.alloc();
            try {
                cu.a(this.tableClass).a(PRIMARY).b(id);
                u in = new u(this.dbh.get(), cu);
                try {
                    int c2;
                    StringBuilder buf = new StringBuilder();
                    while (-1 != (c2 = in.read())) {
                        buf.append((char)c2);
                    }
                    String string = buf.toString();
                    in.close();
                    return string;
                }
                catch (Throwable throwable) {
                    in.close();
                    throw throwable;
                }
            }
            finally {
                CuPool.free(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public long find(String s2) throws DbException {
        ac db = this.dbh.get();
        if (s2 == null) {
            return 0L;
        }
        int hashcode = UniqueStringTableImpl.hashcode(s2);
        y cu = y.a();
        try {
            cu.a(this.tableClass).a(SECONDARY).b((long)hashcode);
            int pkLen = cu.e();
            while (db.a(cu, pkLen)) {
                long sid = cu.v(pkLen);
                if (!Objects.equals(s2, this.get(sid))) continue;
                long l2 = sid;
                return l2;
            }
            long l3 = -1L;
            return l3;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long add(String s2) throws DbException {
        try {
            Object object = this.ID_LOCK;
            synchronized (object) {
                long id = this.find(s2);
                if (id != -1L) {
                    return id;
                }
                id = this.getNextID();
                this.addToPrimary(id, s2);
                this.addToSecondary(id, s2);
                return id;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public SortedIntSet search(final Pattern pattern) throws DbException {
        return this.visit(new IdCollector(new Predicate<CharSequence>(){
            final Matcher matcher;
            {
                this.matcher = pattern.matcher("");
            }

            public boolean apply(CharSequence input) {
                this.matcher.reset(input);
                return this.matcher.find();
            }
        }), 0).results();
    }

    @Override
    public SortedIntSet search(final AntGlob pattern) throws DbException {
        return this.visit(new IdCollector(new Predicate<CharSequence>(){

            public boolean apply(CharSequence input) {
                return pattern.matches(input);
            }
        }), 0).results();
    }

    @Override
    public <V extends UniqueStringTable.Visitor> V visit(V v2, int startId) throws DbException {
        long t0 = System.currentTimeMillis();
        long max = this.getMaxId();
        int id = startId + 1;
        while ((long)id <= max && v2.visit(id, Strings.nullToEmpty((String)this.get(id)))) {
            ++id;
        }
        if (Logs.APP_LOG.isDebugEnabled()) {
            long t1 = System.currentTimeMillis();
            Logs.APP_LOG.debug((Object)("visited UST " + this + " over " + id + " iterations in " + (t1 - t0) + "ms"));
        }
        return v2;
    }

    @Override
    public long getMaxId() throws DbException {
        y cu = y.a();
        try {
            cu.a(this.tableClass).a(CURRENT_ID);
            int p1 = cu.e();
            long maxId = this.dbh.get().a(cu, p1) ? cu.v(p1) : 0L;
            long l2 = maxId;
            return l2;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    @Override
    public void clearCaches() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[table=" + this.tableClass + "]";
    }

    private void addToPrimary(long id, String s2) throws IOException, DbException {
        y cu = y.a();
        cu.a(this.tableClass).a(PRIMARY).b(id);
        v out = new v(this.dbh.get(), cu);
        out.write(s2);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSecondary(long id, String s2) throws DbException, IOException {
        int hashcode = UniqueStringTableImpl.hashcode(s2);
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            cu.a(this.tableClass).a(SECONDARY);
            cu.b((long)hashcode).b(id);
            db.b(cu);
        }
        finally {
            cu.b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextID() throws DbException, IOException {
        Object object = this.ID_LOCK;
        synchronized (object) {
            long l2;
            y cu = y.a();
            try {
                ac db = this.dbh.get();
                cu.a(this.tableClass).a(CURRENT_ID);
                int p1 = cu.e();
                long nextid = db.a(cu, p1) ? cu.v(p1) + 1L : 1L;
                cu.d(p1);
                cu.b(nextid);
                db.e(cu, p1);
                l2 = nextid;
                cu.b();
            }
            catch (Throwable throwable) {
                cu.b();
                throw throwable;
            }
            return l2;
        }
    }

    private static int hashcode(String s2) {
        int h2 = 0;
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            h2 = 31 * h2 + c2;
        }
        return h2;
    }
}

