/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.EntityClassSetUSTDelegatorFactory;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface UniqueStringTable {
    public static final long NULL_ID = 0L;
    public static final long NOT_FOUND_ID = -1L;

    public Object getTableId();

    @Nullable
    public String get(long var1) throws DbException;

    public long find(@Nullable String var1) throws DbException;

    public long add(@Nullable String var1) throws DbException;

    public long getMaxId() throws DbException;

    public SortedIntSet search(Pattern var1) throws DbException;

    public SortedIntSet search(AntGlob var1) throws DbException;

    public <V extends Visitor> V visit(V var1, int var2) throws DbException;

    public void clearCaches();

    public Function<String, Long> stringToId();

    public <T extends Number> Function<T, String> idToString();

    public static interface DelegatorFactory {
        public static final String FACTORY_CLASS = "com.atlassian.fisheye.UniqueStringTable.DelegatorFactory";
        public static final DelegatorFactory DEFAULT_FACTORY = new EntityClassSetUSTDelegatorFactory();

        public UniqueStringTable delegate(UniqueStringTable var1);

        public static class Identity
        implements DelegatorFactory {
            @Override
            public UniqueStringTable delegate(UniqueStringTable delegate) {
                return delegate;
            }
        }

        public static class Builder {
            static DelegatorFactory get() {
                String className = System.getProperty(DelegatorFactory.FACTORY_CLASS);
                if (Strings.isNullOrEmpty((String)className)) {
                    return DEFAULT_FACTORY;
                }
                try {
                    Class<?> factoryClass = Class.forName(className);
                    if (!DelegatorFactory.class.isAssignableFrom(factoryClass)) {
                        Logs.APP_LOG.error((Object)("Configured DelegatorFactory class: '" + className + "' does not implement DelegatorFactory."));
                        return DEFAULT_FACTORY;
                    }
                    return (DelegatorFactory)factoryClass.newInstance();
                }
                catch (ClassNotFoundException e2) {
                    Logs.APP_LOG.error((Object)("Configured DelegatorFactory class: '" + className + "' could not be found."));
                }
                catch (InstantiationException e3) {
                    Logs.APP_LOG.error((Object)("Configured DelegatorFactory class: '" + className + "' could not be instantiated."));
                }
                catch (IllegalAccessException e4) {
                    Logs.APP_LOG.error((Object)("Configured DelegatorFactory class: '" + className + "' could not be accessed."));
                }
                return DEFAULT_FACTORY;
            }
        }
    }

    public static interface Visitor {
        public boolean visit(long var1, @Nonnull CharSequence var3) throws DbException;
    }
}

