/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.atlassian.fisheye.util.DevMode;
import com.cenqua.fisheye.infinitydb.DbStateChangeCallback;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.infinitydb.UniqueStringTableImpl;
import com.cenqua.fisheye.infinitydb.b;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.V;
import com.cenqua.obfuscate.idb.ac;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class InfinityDbHandle
implements UniqueStringTableFactory {
    private static final AtomicLong hits = new AtomicLong();
    private static final AtomicLong misses = new AtomicLong();
    private static final AtomicLong closes = new AtomicLong();
    private final ReentrantLock access = new ReentrantLock();
    private final File file;
    private volatile long desiredCacheSize;
    private volatile long actualCacheSize;
    private final DbStateChangeCallback dbStateChangeCallback;
    private volatile b wrapper;
    private Exception openTrace;

    public InfinityDbHandle(File file) {
        this(file, 2500000L, null);
    }

    public InfinityDbHandle(File file, long desiredCacheSize, DbStateChangeCallback dbStateChangeCallback) {
        this.file = file;
        this.desiredCacheSize = desiredCacheSize;
        this.dbStateChangeCallback = dbStateChangeCallback;
        this.actualCacheSize = 0L;
    }

    public ac get() throws DbException {
        try {
            return this.open();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ac open() throws IOException {
        boolean hit = true;
        if (this.wrapper == null) {
            boolean databaseOpened = false;
            try {
                this.access.lock();
                if (this.wrapper == null) {
                    hit = false;
                    Logs.APP_LOG.debug((Object)("opening " + this.file + " with cachesize=" + this.desiredCacheSize));
                    InfinityDbUtil.createIfNeccessary(this.file);
                    V db = V.a(this.file.getPath(), true, this.desiredCacheSize);
                    this.actualCacheSize = this.desiredCacheSize;
                    if (DevMode.isDevMode()) {
                        this.openTrace = new Exception("DB open Trace");
                    }
                    this.wrapper = new b(db);
                    databaseOpened = true;
                }
            }
            finally {
                this.access.unlock();
            }
            if (this.dbStateChangeCallback != null && databaseOpened) {
                this.dbStateChangeCallback.onOpen(this.actualCacheSize);
            }
        }
        if (hit) {
            hits.getAndIncrement();
        } else {
            misses.getAndIncrement();
        }
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        long currentSize = this.actualCacheSize;
        boolean dbClosed = false;
        try {
            this.access.lock();
            b dbWrapper = this.wrapper;
            this.wrapper = null;
            this.openTrace = null;
            if (dbWrapper != null) {
                Logs.APP_LOG.debug((Object)("closing " + this.file));
                dbWrapper.d();
                closes.getAndIncrement();
                this.actualCacheSize = 0L;
                dbClosed = true;
            }
        }
        finally {
            this.access.unlock();
        }
        if (this.dbStateChangeCallback != null && dbClosed) {
            this.dbStateChangeCallback.onClose(currentSize);
        }
    }

    public void commit() throws IOException {
        try {
            this.access.lock();
            if (this.wrapper != null) {
                this.wrapper.c();
            }
        }
        finally {
            this.access.unlock();
        }
    }

    public void rollback() throws IOException {
        try {
            this.access.lock();
            if (this.wrapper != null) {
                this.wrapper.b();
            }
        }
        finally {
            this.access.unlock();
        }
    }

    public boolean isOpen() {
        try {
            this.access.lock();
            boolean bl = this.wrapper != null;
            return bl;
        }
        finally {
            this.access.unlock();
        }
    }

    public boolean isDirty() {
        return this.wrapper.k();
    }

    public long getDesiredCacheSize() {
        return this.desiredCacheSize;
    }

    public void setDesiredCacheSize(long desiredCacheSize) {
        this.desiredCacheSize = desiredCacheSize;
    }

    public File getFile() {
        return this.file;
    }

    public Exception getOpenTrace() {
        return this.openTrace;
    }

    @Override
    public UniqueStringTable createUniqueStringTable(Object tableId) {
        return UniqueStringTable.DelegatorFactory.Builder.get().delegate(new UniqueStringTableImpl(this, (I)tableId));
    }

    public static AccessStats getAccessStats() {
        return new AccessStats(hits.get(), misses.get(), closes.get());
    }

    public static class AccessStats {
        private final long hitCount;
        private final long missCount;
        private final long closeCount;

        public AccessStats(long hitCount, long missCount, long closeCount) {
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.closeCount = closeCount;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getMissCount() {
            return this.missCount;
        }

        public long getTotalCount() {
            return this.hitCount + this.missCount;
        }

        public long getCloseCount() {
            return this.closeCount;
        }

        public double getHitRate() {
            long totalCount = this.getTotalCount();
            return totalCount == 0L ? 1.0 : (double)this.hitCount / (double)totalCount;
        }

        public boolean isSignificantChangeFrom(AccessStats otherStats) {
            return otherStats == null || this.closeCount != otherStats.closeCount || this.missCount != otherStats.missCount;
        }
    }
}

