/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.atlassian.fecru.util.ListIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.NotImplementedException;

public abstract class InfDbIterable<T>
implements ListIterable<T> {
    private final InfinityDbHandle dbh;
    private final y cu;
    private final int elementOffset;

    public InfDbIterable(InfinityDbHandle dbh, y cu, int elementOffset) {
        this.dbh = dbh;
        this.cu = cu;
        this.elementOffset = elementOffset;
    }

    public abstract T getElement(y var1, int var2) throws IOException, DbException;

    @Override
    public ListIterator<T> iterator() {
        return new InfDbListIterator(this.cu);
    }

    @Override
    public ListIterator<T> iteratorFromEnd() {
        y endCu = y.b(this.cu);
        endCu.d(this.elementOffset).j();
        return new InfDbListIterator(endCu);
    }

    public class InfDbListIterator
    implements ListIterator<T> {
        private final y cu;
        private final y prevCu = y.a();
        private final y nextCu = y.a();
        private Boolean hasNext = null;
        private Boolean hasPrev = null;
        private boolean elemReturned = false;

        public InfDbListIterator(y cu) {
            this.cu = y.b(cu);
        }

        @Override
        public void add(T e2) {
            throw new NotImplementedException();
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext == null) {
                try {
                    this.nextCu.f().e(this.cu);
                    this.hasNext = InfDbIterable.this.dbh.get().a(this.nextCu, InfDbIterable.this.elementOffset);
                }
                catch (IOException e2) {
                    throw new DbException("an error occurred while retrieving the next element", e2);
                }
            }
            return this.hasNext;
        }

        @Override
        public boolean hasPrevious() {
            if (this.hasPrev == null) {
                try {
                    this.prevCu.f().e(this.cu);
                    this.hasPrev = InfDbIterable.this.dbh.get().c(this.prevCu, InfDbIterable.this.elementOffset);
                }
                catch (IOException e2) {
                    throw new DbException("an error occurred while retrieving the previous element", e2);
                }
            }
            return this.hasPrev;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.hasPrev = this.elemReturned;
                this.hasNext = null;
                this.elemReturned = true;
                this.prevCu.f().e(this.cu);
                this.cu.f().e(this.nextCu);
                try {
                    return InfDbIterable.this.getElement(this.cu, InfDbIterable.this.elementOffset);
                }
                catch (IOException e2) {
                    throw new DbException("an error occurred while retrieving the next element", e2);
                }
            }
            throw new NoSuchElementException("There is no next element");
        }

        @Override
        public int nextIndex() {
            throw new NotImplementedException();
        }

        @Override
        public T previous() {
            if (this.hasPrevious()) {
                this.hasNext = this.elemReturned;
                this.hasPrev = null;
                this.elemReturned = true;
                this.nextCu.f().e(this.cu);
                this.cu.f().e(this.prevCu);
                try {
                    return InfDbIterable.this.getElement(this.cu, InfDbIterable.this.elementOffset);
                }
                catch (IOException e2) {
                    throw new DbException("an error occurred while retrieving the previous element", e2);
                }
            }
            throw new NoSuchElementException("There is no previous element");
        }

        @Override
        public int previousIndex() {
            throw new NotImplementedException();
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void set(T e2) {
            throw new NotImplementedException();
        }
    }
}

