/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.SimpleIndex;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.RevisionDateRange;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.X;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EavEntityCu {
    private final ac db;
    private final y cu;
    private final y pkVal;
    private final int cuPkLen;

    public EavEntityCu(ac db, I entity, y pk) {
        this.db = db;
        this.cu = y.a().a(entity).e(pk);
        this.pkVal = y.b(pk);
        this.cuPkLen = this.cu.e();
    }

    public EavEntityCu(ac db, I entity, long pk) {
        this(db, entity, y.a().b(pk));
    }

    public EavEntityCu(ac db, I entity, String pk) {
        this(db, entity, y.a().b(pk));
    }

    public y getPk() {
        return y.b(this.pkVal);
    }

    public void createPK() throws IOException {
        try {
            if (!this.db.a_(this.cu)) {
                this.db.b(this.cu);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(p attr, y val) throws IOException {
        try {
            this.cu.a(attr);
            int pl = this.cu.e();
            this.cu.e(val);
            this.db.e(this.cu, pl);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(p attr, boolean val) throws IOException {
        try {
            this.cu.a(attr);
            int pl = this.cu.e();
            this.cu.a(val);
            this.db.e(this.cu, pl);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public void updateInt(p attr, int val) throws IOException {
        this.updateLong(attr, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(p attr, long val) throws IOException {
        try {
            this.cu.a(attr);
            int pl = this.cu.e();
            this.cu.b(val);
            this.db.e(this.cu, pl);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeyedValue(p attr, long key, long value) throws IOException {
        try {
            this.cu.a(attr).b(key);
            int pl = this.cu.e();
            this.cu.b(value);
            this.db.e(this.cu, pl);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Long> getKeyValueMap(p attr) throws IOException {
        HashMap<Long, Long> keyValueMap = new HashMap<Long, Long>();
        try {
            this.cu.a(attr);
            int keyOffset = this.cu.e();
            while (this.db.a(this.cu, keyOffset)) {
                long key = this.cu.v(keyOffset);
                int valueOffset = this.cu.w(keyOffset);
                long value = this.cu.v(valueOffset);
                keyValueMap.put(key, value);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
        return keyValueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLongArray(p attr, long[] value) throws IOException {
        try {
            this.cu.a(attr);
            int pl = this.cu.e();
            for (int i2 = 0; i2 < value.length; ++i2) {
                this.cu.b(value[i2]);
            }
            this.db.e(this.cu, pl);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(p attr, String val) throws IOException {
        try {
            if (val == null) {
                this.deleteValues(attr);
            } else {
                this.cu.a(attr);
                int pl = this.cu.e();
                this.cu.b(val);
                this.db.e(this.cu, pl);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(UniqueStringTable stringTable, p attr, String value) throws IOException, DbException {
        try {
            this.deleteValues(attr);
            this.addLong(attr, stringTable.add(value));
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStrings(p attr, List<String> values) throws IOException {
        try {
            this.deleteValues(attr);
            for (String val : values) {
                this.addString(attr, val);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStringsOrdered(UniqueStringTable stringTable, p attr, List<String> values) throws IOException, DbException {
        try {
            this.deleteValues(attr);
            for (int index = 0; index < values.size(); ++index) {
                this.cu.d(this.cuPkLen);
                this.cu.a(attr);
                this.cu.b((long)index);
                this.cu.b(stringTable.add(values.get(index)));
                this.db.b(this.cu);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStrings(UniqueStringTable stringTable, p attr, Collection<String> values) throws IOException, DbException {
        try {
            this.deleteValues(attr);
            for (String val : values) {
                this.addLong(attr, stringTable.add(val));
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public void addString(p attr, String val) throws IOException {
        try {
            this.cu.a(attr);
            this.cu.b(val);
            this.db.b(this.cu);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLong(p attr, long val) throws IOException {
        try {
            this.cu.a(attr);
            this.cu.b(val);
            this.db.b(this.cu);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public void addInt(p attr, int val) throws IOException {
        this.addLong(attr, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNoDupLong(p attr, long val) throws IOException {
        boolean added = false;
        try {
            this.cu.a(attr);
            this.cu.b(val);
            if (!this.db.a_(this.cu)) {
                this.db.b(this.cu);
                added = true;
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteLong(p attr, long val) throws IOException {
        boolean deleted = false;
        try {
            this.cu.a(attr);
            this.cu.b(val);
            if (this.db.a_(this.cu)) {
                this.db.c(this.cu);
                deleted = true;
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
        return deleted;
    }

    public int getInt(p attr, int defaultValue) throws IOException {
        return (int)this.getLong(attr, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(p attr, long defaultValue) throws IOException {
        try {
            this.cu.a(attr);
            int valueOffset = this.cu.e();
            long l2 = this.db.a(this.cu, valueOffset) ? this.cu.v(valueOffset) : defaultValue;
            return l2;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongList getLongs(p attr) throws IOException {
        try {
            LongArrayList result = new LongArrayList();
            this.cu.a(attr);
            int valueOffset = this.cu.e();
            while (this.db.a(this.cu, valueOffset)) {
                result.add(this.cu.v(valueOffset));
            }
            LongArrayList longArrayList = result;
            return longArrayList;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongList getLongsOrdered(p attr) throws IOException {
        try {
            LongArrayList result = new LongArrayList();
            this.cu.a(attr);
            int indexOffset = this.cu.e();
            while (this.db.a(this.cu, indexOffset)) {
                int valueOffset = this.cu.w(indexOffset);
                result.add(this.cu.v(valueOffset));
            }
            LongArrayList longArrayList = result;
            return longArrayList;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLongArray(p attr) throws IOException {
        try {
            this.cu.a(attr);
            int valueOffset = this.cu.e();
            if (this.db.a(this.cu, valueOffset)) {
                long[] value = null;
                int nextValueOffset = valueOffset;
                while (nextValueOffset < this.cu.e()) {
                    if (value != null) {
                        long[] newVal = new long[value.length + 1];
                        System.arraycopy(value, 0, newVal, 0, value.length);
                        value = newVal;
                    } else {
                        value = new long[1];
                    }
                    value[value.length - 1] = this.cu.v(nextValueOffset);
                    nextValueOffset = this.cu.w(nextValueOffset);
                }
                long[] lArray = value;
                return lArray;
            }
            long[] lArray = null;
            return lArray;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(p attr, boolean defaultValue) throws IOException {
        try {
            this.cu.a(attr);
            int valueOffset = this.cu.e();
            boolean bl = this.db.a(this.cu, valueOffset) ? this.cu.s(valueOffset) : defaultValue;
            return bl;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(p attr, String defaultValue) throws IOException {
        try {
            this.cu.a(attr);
            int valueOffset = this.cu.e();
            String string = this.db.a(this.cu, valueOffset) ? this.cu.m(valueOffset) : defaultValue;
            return string;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public String getString(UniqueStringTable stringTable, p attr, String defaultValue) throws IOException, DbException {
        String value;
        String result = defaultValue;
        long id = this.getLong(attr, -1L);
        if (id != -1L && (value = stringTable.get(id)) != null) {
            result = value;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStrings(p attr) throws IOException {
        try {
            LinkedList<String> result = new LinkedList<String>();
            this.cu.a(attr);
            int valueOffset = this.cu.e();
            while (this.db.a(this.cu, valueOffset)) {
                result.add(this.cu.m(valueOffset));
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public List<String> getStrings(UniqueStringTable stringTable, p attr) throws IOException, DbException {
        return Lists.transform((List)this.getLongs(attr), stringTable.idToString());
    }

    public List<String> getStringsOrdered(UniqueStringTable stringTable, p attr) throws IOException, DbException {
        return Lists.transform((List)this.getLongsOrdered(attr), stringTable.idToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getInts(p attr) throws IOException {
        try {
            LinkedList<Integer> result = new LinkedList<Integer>();
            this.cu.a(attr);
            int valueOffset = this.cu.e();
            while (this.db.a(this.cu, valueOffset)) {
                result.add((int)this.cu.v(valueOffset));
            }
            LinkedList<Integer> linkedList = result;
            return linkedList;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevisionDateRange getRevisionDateRange(p attr, RevisionDateRange defaultValue) throws IOException {
        try {
            this.cu.a(attr);
            int off = this.cu.e();
            if (this.db.a(this.cu, off)) {
                RevisionDateRange val = new RevisionDateRange();
                val.readFromCursor(this.cu, off);
                RevisionDateRange revisionDateRange = val;
                return revisionDateRange;
            }
            RevisionDateRange revisionDateRange = defaultValue;
            return revisionDateRange;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getValue(p att, y result) throws IOException {
        try {
            this.cu.a(att);
            int offsetOfValue = this.cu.e();
            if (this.db.a(this.cu, offsetOfValue)) {
                result.c(this.cu, offsetOfValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public boolean exists() throws IOException {
        try {
            int offsetOfValue = this.cu.e();
            boolean bl = this.db.b(this.cu, offsetOfValue);
            return bl;
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public void deleteValues(p attr) throws IOException {
        try {
            this.cu.a(attr);
            int p1 = this.cu.e();
            while (this.db.b(this.cu, p1)) {
                this.db.c(this.cu);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public void deleteEntity() throws IOException {
        try {
            int p1 = this.cu.e();
            while (this.db.b(this.cu, p1)) {
                this.db.c(this.cu);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStringInversion(X inversion, String str) throws IOException {
        try {
            if (str == null) {
                inversion.d(this.db, this.pkVal);
            } else {
                y val = y.a();
                val.b(str);
                inversion.e(this.db, this.pkVal, val);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public void updateValueIndex(SimpleIndex index, y val) throws IOException {
        try {
            index.update(this.db, this.pkVal, val);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStringIndex(SimpleIndex index, String str) throws IOException {
        try {
            if (str == null) {
                index.clear(this.db, this.pkVal);
            } else {
                y val = y.a();
                val.b(str);
                index.update(this.db, this.pkVal, val);
            }
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLongInversion(X inversion, long l2) throws IOException {
        try {
            y val = y.a();
            val.b(l2);
            inversion.e(this.db, this.pkVal, val);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLongIndex(SimpleIndex inversion, long l2) throws IOException {
        try {
            y val = y.a();
            val.b(l2);
            inversion.update(this.db, this.pkVal, val);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBooleanInversion(X inversion, boolean v2) throws IOException {
        try {
            y val = y.a();
            val.a(v2);
            inversion.e(this.db, this.pkVal, val);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }

    public void deleteInversion(X inversion) throws IOException {
        try {
            inversion.d(this.db, this.pkVal);
        }
        finally {
            this.cu.d(this.cuPkLen);
        }
    }
}

