/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.AbstractUniqueStringTable;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.regex.Pattern;

public final class CachingUniqueStringTable
extends AbstractUniqueStringTable {
    private static final int DEFAULT_INITIAL_CACHE_SIZE = 65536;
    private static final Null npe = new Null();
    private final UniqueStringTable delegate;
    private final Cache<Long, String> strings;
    private final Cache<String, Long> longs;
    private Interner<String> interner = Interners.newWeakInterner();

    public CachingUniqueStringTable(final UniqueStringTable delegate) {
        this.delegate = delegate;
        int initialCacheSize = CachingUniqueStringTable.initialCacheSize(delegate);
        this.strings = new Cache<Long, String>(initialCacheSize, (CacheLoader)new CacheLoader<Long, String>(){

            public String load(Long id) {
                String s2 = delegate.get(id);
                if (s2 == null) {
                    throw npe;
                }
                return (String)CachingUniqueStringTable.this.interner.intern((Object)s2);
            }
        }){

            @Override
            CacheBuilder configure(CacheBuilder m2) {
                return m2.softValues();
            }
        };
        this.longs = new Cache<String, Long>(initialCacheSize, (CacheLoader)new CacheLoader<String, Long>(){

            public Long load(String s2) {
                return delegate.find(s2);
            }
        }){

            @Override
            CacheBuilder configure(CacheBuilder m2) {
                return m2.weakKeys();
            }
        };
    }

    @Override
    public String get(long id) throws DbException {
        if (id == 0L) {
            return null;
        }
        return this.strings.get(id);
    }

    @Override
    public long find(String s2) throws DbException {
        if (s2 == null) {
            return 0L;
        }
        return this.longs.get((String)this.interner.intern((Object)s2));
    }

    @Override
    public long add(String s2) throws DbException {
        long id = this.find(s2);
        if (id == -1L) {
            if (s2 == null) {
                return 0L;
            }
            s2 = (String)this.interner.intern((Object)s2);
            id = this.delegate.add(s2);
            this.longs.put(s2, id);
            this.strings.put(id, s2);
        }
        return id;
    }

    @Override
    public Object getTableId() {
        return this.delegate.getTableId();
    }

    @Override
    public long getMaxId() throws DbException {
        return this.delegate.getMaxId();
    }

    @Override
    public SortedIntSet search(Pattern pattern) throws DbException {
        return this.delegate.search(pattern);
    }

    @Override
    public SortedIntSet search(AntGlob pattern) throws DbException {
        return this.delegate.search(pattern);
    }

    @Override
    public <V extends UniqueStringTable.Visitor> V visit(V v2, int startId) throws DbException {
        return this.delegate.visit(v2, startId);
    }

    @Override
    public void clearCaches() {
        this.strings.clear();
        this.longs.clear();
        this.interner = Interners.newWeakInterner();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegate=" + this.delegate + "]";
    }

    private static int initialCacheSize(UniqueStringTable delegate) throws RuntimeException {
        int maxId;
        try {
            maxId = (int)delegate.getMaxId();
        }
        catch (DbException e2) {
            throw new RuntimeException(e2);
        }
        return maxId < 16 ? 16 : Math.min(maxId, 65536);
    }

    private static final class Null
    extends ComputationException {
        public Null() {
            super(null);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static abstract class Cache<K, V> {
        private final LoadingCache<K, V> cache;

        Cache(int initialCacheSize, CacheLoader<K, V> create) {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(initialCacheSize);
            this.cache = this.configure(cacheBuilder).build(create);
        }

        abstract CacheBuilder configure(CacheBuilder var1);

        V get(K k2) throws DbException {
            try {
                return (V)this.cache.getUnchecked(k2);
            }
            catch (UncheckedExecutionException e2) {
                Throwable t2 = e2.getCause();
                if (t2 == npe) {
                    return null;
                }
                Throwables.propagateIfPossible((Throwable)t2);
                throw e2;
            }
        }

        void remove(K key) {
            this.cache.invalidate(key);
        }

        void put(K key, V value) {
            this.cache.put(key, value);
        }

        void clear() {
            this.cache.invalidateAll();
        }
    }
}

