/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.histogram;

import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.csindex.ActivityCalendar;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.fisheye.vis.ColourScheme;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;

public class FisheyeChartFactory {
    public static JFreeChart createDailyCommitChart(ActivityItemSearchParams params, Principal user, ColourScheme colourScheme, boolean splitByDir) throws DbException {
        return FisheyeChartFactory.createCommitChart(params, ChartType.BY_DAY, user, colourScheme, splitByDir);
    }

    public static void outputDailyCommitJson(OutputStreamWriter writer, ActivityItemSearchParams params, Principal user, boolean splitByDir, ColourScheme colourScheme) throws DbException, JSONException, IOException {
        DefaultCategoryDataset dataset = FisheyeChartFactory.getData(params, ChartType.BY_DAY, colourScheme, splitByDir, user);
        FisheyeChartFactory.outputCategoryDataset(writer, dataset);
    }

    public static void outputHourlyCommitJson(OutputStreamWriter writer, ActivityItemSearchParams params, Principal user, boolean splitByDir, ColourScheme colourScheme) throws DbException, JSONException, IOException {
        DefaultCategoryDataset dataset = FisheyeChartFactory.getData(params, ChartType.BY_HOUR, colourScheme, splitByDir, user);
        FisheyeChartFactory.outputCategoryDataset(writer, dataset);
    }

    private static void outputCategoryDataset(OutputStreamWriter writer, DefaultCategoryDataset dataset) throws JSONException, IOException {
        JSONArray seriesLabeles = new JSONArray();
        JSONArray categoryLabels = new JSONArray();
        JSONArray data1 = new JSONArray();
        for (int i2 = 0; i2 < dataset.getRowCount(); ++i2) {
            seriesLabeles.put((Object)dataset.getRowKey(i2));
            JSONArray data2 = new JSONArray();
            for (int j2 = 0; j2 < dataset.getColumnCount(); ++j2) {
                if (i2 == 0) {
                    categoryLabels.put((Object)dataset.getColumnKey(j2));
                }
                data2.put((Object)dataset.getValue(i2, j2));
            }
            data1.put((Object)data2);
        }
        JSONWriter jWriter = new JSONWriter((Writer)writer);
        jWriter.object();
        jWriter.key("seriesLabels").value((Object)seriesLabeles);
        jWriter.key("categoryLabels").value((Object)categoryLabels);
        jWriter.key("data").value((Object)data1);
        jWriter.endObject();
        writer.append("\n");
        writer.close();
    }

    public static JFreeChart createHourlyCommitChart(ActivityItemSearchParams params, Principal user, ColourScheme colourScheme, boolean splitByDir) throws DbException {
        return FisheyeChartFactory.createCommitChart(params, ChartType.BY_HOUR, user, colourScheme, splitByDir);
    }

    public static ActivityCalendar createActivityCalendar(ActivityItemSearchParams params, Principal user) throws DbException {
        ActivityCalendarCreator activityCalendarCreator = new ActivityCalendarCreator();
        FisheyeChartFactory.getChartData(params, user, activityCalendarCreator, false);
        return activityCalendarCreator.calendar;
    }

    public static void outputActivityCalendarJson(OutputStreamWriter writer, ActivityItemSearchParams params, Principal user, boolean splitByDir) throws DbException, JSONException, IOException {
        ActivityCalendarCreator activityCalendarCreator = new ActivityCalendarCreator();
        FisheyeChartFactory.getChartData(params, user, activityCalendarCreator, false);
        JSONArray years = new JSONArray();
        JSONArray data1 = new JSONArray();
        for (ActivityCalendar.Year e2 : activityCalendarCreator.calendar.getYears()) {
            years.put((Object)String.valueOf(e2.getYear()));
            JSONArray data2 = new JSONArray();
            for (ActivityCalendar.Month e22 : e2.getMonths()) {
                data2.put(e22.getCount());
            }
            data1.put((Object)data2);
        }
        JSONWriter jWriter = new JSONWriter((Writer)writer);
        jWriter.object();
        jWriter.key("years").value((Object)years);
        jWriter.key("data").value((Object)data1);
        jWriter.endObject();
        writer.append("\n");
        writer.close();
    }

    public static void outputCommitSparklineJson(OutputStreamWriter writer, ActivityItemSearchParams params, Principal user, boolean splitByDir) throws DbException, JSONException, IOException {
        SparklineChartCreator sparklineChartCreator = new SparklineChartCreator(splitByDir);
        FisheyeChartFactory.getChartData(params, user, sparklineChartCreator, splitByDir);
        JSONArray seriesLabels = new JSONArray();
        JSONArray categoryLabels = new JSONArray();
        JSONArray data1 = new JSONArray();
        boolean first = true;
        for (Map.Entry<String, Object2IntMap<String>> e2 : sparklineChartCreator.result.entrySet()) {
            seriesLabels.put((Object)e2.getKey());
            JSONArray data2 = new JSONArray();
            for (Map.Entry e22 : e2.getValue().entrySet()) {
                if (first) {
                    categoryLabels.put(e22.getKey());
                }
                data2.put(e22.getValue());
            }
            data1.put((Object)data2);
            first = false;
        }
        JSONWriter jWriter = new JSONWriter((Writer)writer);
        jWriter.object();
        jWriter.key("seriesLabels").value((Object)seriesLabels);
        jWriter.key("categoryLabels").value((Object)categoryLabels);
        jWriter.key("data").value((Object)data1);
        jWriter.endObject();
        writer.append("\n");
        writer.close();
    }

    public static JFreeChart createCommitSparkline(ActivityItemSearchParams params, Principal user, ColourScheme colourScheme, boolean splitByDir) throws DbException {
        SparklineChartCreator sparklineChartCreator = new SparklineChartCreator(splitByDir);
        FisheyeChartFactory.getChartData(params, user, sparklineChartCreator, splitByDir);
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        for (Map.Entry<String, Object2IntMap<String>> dataSeries : sparklineChartCreator.result.entrySet()) {
            colourScheme.addKey(dataSeries.getKey());
            for (Object2IntMap.Entry e2 : dataSeries.getValue().object2IntEntrySet()) {
                Calendar cal = Calendar.getInstance(params.getTz());
                int week = Integer.parseInt((String)e2.getKey()) % 100;
                int year = (Integer.parseInt((String)e2.getKey()) - week) / 100;
                cal.set(1, year);
                cal.set(3, week - 1);
                cal.set(7, 0);
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                data.addValue((double)e2.getIntValue(), (Comparable)((Object)dataSeries.getKey()), (Comparable)((Object)format.format(cal.getTime())));
            }
        }
        CategoryPlot plot = new CategoryPlot();
        plot.setDataset((CategoryDataset)data);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setOutlineVisible(false);
        NumberAxis rangeAxis = new NumberAxis();
        rangeAxis.setVisible(false);
        rangeAxis.setDefaultAutoRange(new Range(0.0, 1.0));
        plot.setRangeAxis((ValueAxis)rangeAxis);
        CategoryAxis domainAxis = new CategoryAxis();
        domainAxis.setVisible(true);
        domainAxis.setTickLabelsVisible(false);
        domainAxis.setAxisLineVisible(true);
        domainAxis.setAxisLinePaint((Paint)Color.LIGHT_GRAY);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        plot.setDomainAxis(domainAxis);
        StackedBarRenderer renderer = new StackedBarRenderer();
        for (int i2 = 0; i2 < data.getRowCount(); ++i2) {
            renderer.setSeriesPaint(i2, (Paint)colourScheme.getBarColour(i2, data.getRowKey(i2)));
        }
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("{2} commits in {0} during week starting {1}", NumberFormat.getInstance()));
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)colourScheme.getBackgroundColour());
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)colourScheme.getBackgroundColour());
        return chart;
    }

    private static void getChartData(ActivityItemSearchParams params, Principal user, ChartCreator chartCreator, boolean splitByDir) throws DbException {
        if (params == null || params.getCrossRepConstraints() == null) {
            chartCreator.getData(params, user);
        } else {
            RepositoryConstraints constraints = params.getCrossRepConstraints();
            for (RepositoryHandle repHandle : RepositoryUtil.repositories(user)) {
                RepositoryConstraints.RepositoryConstraint item = constraints.getConstraintsForRep(repHandle.getName());
                if (item == null) continue;
                if (splitByDir && item.getPaths().size() > 1) {
                    for (Path path : item.getPaths()) {
                        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.Builder.fromParams(params);
                        builder.repository(repHandle.getName());
                        builder.path(repHandle.getName(), path);
                        for (String committer : item.getCommitters()) {
                            builder.anyCommitter(repHandle.getName(), committer);
                        }
                        chartCreator.getData(builder.build(), user);
                    }
                    continue;
                }
                ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.Builder.fromParams(params);
                builder.repository(repHandle.getName());
                for (Path path : item.getPaths()) {
                    builder.path(repHandle.getName(), path);
                }
                for (String committer : item.getCommitters()) {
                    builder.anyCommitter(repHandle.getName(), committer);
                }
                chartCreator.getData(builder.build(), user);
            }
        }
    }

    private static boolean userHasPermission(RepositoryHandle handle, Principal user) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        return um.hasPermissionToAccess(user, handle);
    }

    private static JFreeChart createCommitChart(ActivityItemSearchParams params, ChartType type, Principal user, ColourScheme colourScheme, boolean splitByDir) throws DbException {
        DefaultCategoryDataset dataset = FisheyeChartFactory.getData(params, type, colourScheme, splitByDir, user);
        JFreeChart chart = FisheyeChartFactory.getChart(dataset);
        FisheyeChartFactory.format(chart, type, dataset.getColumnKeys(), colourScheme, dataset);
        return chart;
    }

    private static DefaultCategoryDataset getData(ActivityItemSearchParams params, ChartType type, ColourScheme colourScheme, boolean splitByDir, Principal user) throws DbException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List<RepositoryHandle> repositoryHandles = RepositoryUtil.repositories(user);
        Collections.sort(repositoryHandles, new Comparator<RepositoryHandle>(){

            @Override
            public int compare(RepositoryHandle o1, RepositoryHandle o2) {
                int diff = o1.getName().compareTo(o2.getName());
                if (diff != 0) {
                    return diff;
                }
                return o1.hashCode() - o2.hashCode();
            }
        });
        for (RepositoryHandle repHandle : repositoryHandles) {
            try {
                if (!repHandle.isRunning()) continue;
                RepositoryConstraints constraints = params.getCrossRepConstraints();
                if (constraints == null && (params.getRepFilter() == null || params.getRepFilter().equals(repHandle.getName()))) {
                    FisheyeChartFactory.addData(repHandle, dataset, params, type, splitByDir);
                    colourScheme.addKey(repHandle.getName());
                    continue;
                }
                if (constraints == null || constraints.getConstraintsForRep(repHandle.getName()) == null) continue;
                RepositoryConstraints.RepositoryConstraint item = constraints.getConstraintsForRep(repHandle.getName());
                if (splitByDir && item.getPaths().size() > 1) {
                    for (Path path : item.getPaths()) {
                        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.Builder.fromParams(params);
                        builder.path(repHandle.getName(), path);
                        for (String committer : item.getCommitters()) {
                            builder.anyCommitter(repHandle.getName(), committer);
                        }
                        FisheyeChartFactory.addData(repHandle, dataset, builder.build(), type, splitByDir);
                        colourScheme.addKey(repHandle.getName());
                    }
                    continue;
                }
                ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.Builder.fromParams(params);
                for (Path path : item.getPaths()) {
                    builder.path(repHandle.getName(), path);
                }
                for (String committer : item.getCommitters()) {
                    builder.anyCommitter(repHandle.getName(), committer);
                }
                FisheyeChartFactory.addData(repHandle, dataset, builder.build(), type, splitByDir);
                colourScheme.addKey(repHandle.getName());
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.debug((Object)"Error getting commit data", (Throwable)((Object)e2));
            }
        }
        return dataset;
    }

    private static void addData(RepositoryHandle handle, DefaultCategoryDataset dataset, ActivityItemSearchParams params, ChartType type, boolean splitByDir) throws RepositoryHandle.StateException, DbException {
        RepositoryEngine engine = handle.acquireEngine();
        Object2IntMap<String> moreData = FisheyeChartFactory.getData(engine, params, type);
        String repname = handle.getName();
        for (Object2IntMap.Entry e2 : moreData.object2IntEntrySet()) {
            String column = (String)e2.getKey();
            String seriesKey = repname;
            if (splitByDir) {
                List<Path> paths = params.getPaths();
                seriesKey = paths.isEmpty() ? repname + " root" : repname + " " + paths.get(0);
            }
            if (dataset.getColumnKeys().contains(column)) {
                int prevValue = 0;
                if (dataset.getRowKeys().contains(seriesKey) && dataset.getValue((Comparable)((Object)seriesKey), (Comparable)((Object)column)) != null) {
                    prevValue = dataset.getValue((Comparable)((Object)seriesKey), (Comparable)((Object)column)).intValue();
                }
                Double d2 = (double)prevValue + (double)((Integer)e2.getValue()).intValue();
                dataset.addValue((Number)d2, (Comparable)((Object)seriesKey), (Comparable)((Object)column));
                continue;
            }
            Double d3 = (double)((Integer)e2.getValue());
            dataset.addValue((Number)d3, (Comparable)((Object)seriesKey), (Comparable)((Object)column));
        }
    }

    private static Object2IntMap<String> getData(RepositoryEngine engine, ActivityItemSearchParams params, ChartType type) throws DbException {
        Object2IntMap<String> data;
        ChangesetStatsCalculator calculator = engine.makeChangesetHistoryCalculator(params);
        switch (type) {
            case BY_HOUR: {
                double offset = 0.0;
                if (type == ChartType.BY_HOUR) {
                    TimeZone repTimeZone = DateHelper.GMT;
                    offset = (long)(-(repTimeZone.getRawOffset() - params.getTz().getRawOffset())) / 3600000L;
                }
                data = calculator.activityByHour(engine.getCrossRepLuceneConnection(), offset);
                break;
            }
            case BY_DAY: {
                data = calculator.activityByDay(engine.getCrossRepLuceneConnection());
                break;
            }
            default: {
                data = new Object2IntMap<String>();
            }
        }
        return data;
    }

    private static JFreeChart getChart(DefaultCategoryDataset dataset) {
        return ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
    }

    private static void format(JFreeChart chart, ChartType type, List<String> keys, ColourScheme colourScheme, DefaultCategoryDataset data) {
        chart.setBackgroundPaint((Paint)colourScheme.getBackgroundColour());
        chart.setBorderPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setMaximumBarWidth(0.03);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setRangeCrosshairVisible(false);
        plot.setOutlineVisible(false);
        plot.setAnchorValue(1.0);
        plot.setBackgroundPaint((Paint)colourScheme.getBackgroundColour());
        ValueAxis axis = plot.getRangeAxis();
        axis.setAxisLineVisible(false);
        axis.setTickMarksVisible(false);
        axis.setTickLabelsVisible(false);
        if (type == ChartType.BY_HOUR) {
            int hourPeriod = 4;
            boolean littleSize = true;
            int bigSize = 10;
            CategoryAxis domain = plot.getDomainAxis();
            Font labelFont = domain.getTickLabelFont((Comparable)Integer.valueOf(0));
            Font littleFont = new Font(labelFont.getName(), labelFont.getStyle(), 1);
            Font bigFont = new Font(labelFont.getName(), labelFont.getStyle(), 10);
            domain.setTickMarkOutsideLength(1.0f);
            domain.setTickLabelFont(littleFont);
            domain.setTickLabelPaint((Paint)Color.WHITE);
            Iterator<String> it = keys.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                String current = it.next();
                if (i2 % 4 == 0) {
                    domain.setTickLabelPaint((Comparable)((Object)current), (Paint)Color.BLACK);
                    domain.setTickLabelFont((Comparable)((Object)current), bigFont);
                }
                ++i2;
            }
        }
        for (int i3 = 0; i3 < data.getRowCount(); ++i3) {
            renderer.setSeriesPaint(i3, (Paint)colourScheme.getBarColour(i3, data.getRowKey(i3)));
        }
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("{2} commits in {0}", NumberFormat.getInstance()));
        plot.setRenderer((CategoryItemRenderer)renderer);
    }

    private static LuceneConnection<CrossRepLuceneIndexes> getConnection() {
        CrossRepLuceneIndex crossRepLuceneIndex = AppConfig.getsConfig().getCrossRepLuceneIndex();
        return crossRepLuceneIndex.getConnection();
    }

    private static class ActivityCalendarCreator
    implements ChartCreator {
        ActivityCalendar calendar = new ActivityCalendar();

        private ActivityCalendarCreator() {
        }

        @Override
        public void getData(ActivityItemSearchParams params, Principal user) throws DbException {
            if (params != null) {
                ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(params);
                RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
                RepositoryHandle handle = rm.getRepository(params.getRepFilter());
                if (handle != null && handle.isRunning() && FisheyeChartFactory.userHasPermission(handle, user)) {
                    calculator.activityCalendar(FisheyeChartFactory.getConnection(), this.calendar);
                }
            }
        }
    }

    private static class SparklineChartCreator
    implements ChartCreator {
        Map<String, Object2IntMap<String>> result = new TreeMap<String, Object2IntMap<String>>();
        private boolean splitByDir;

        public SparklineChartCreator(boolean splitByDir) {
            this.splitByDir = splitByDir;
        }

        @Override
        public void getData(ActivityItemSearchParams params, Principal user) throws DbException {
            SumMap<String> map = ChangesetIndexer.getEmptyWeekMapForLastYear();
            if (params != null) {
                ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(params);
                RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
                RepositoryHandle handle = rm.getRepository(params.getRepFilter());
                if (handle != null && handle.isRunning() && FisheyeChartFactory.userHasPermission(handle, user)) {
                    calculator.getCommitVolumeForPastYearByWeek(FisheyeChartFactory.getConnection(), map);
                }
                String seriesLabel = params.getRepFilter();
                if (this.splitByDir) {
                    seriesLabel = params.getPaths().size() == 0 ? params.getRepFilter() + " root" : params.getRepFilter() + " " + params.getPaths().get(0);
                }
                this.result.put(seriesLabel, map.getMap());
            } else {
                this.result.put("", map.getMap());
            }
        }
    }

    private static interface ChartCreator {
        public void getData(ActivityItemSearchParams var1, Principal var2) throws DbException;
    }

    public static enum ChartType {
        BY_HOUR,
        BY_DAY;

    }
}

